@php 

$setting = \App\Setting::first();
$snow = 0; 

@endphp
@if(\Auth::guest())
@php $snow = 0;  @endphp
@endif
@if(\Auth::user() && \Auth::user()->admin != 1)
@php $snow = 0;  @endphp
@endif

@php $snow = $setting->theme; @endphp

@if(\Auth::user() && \Auth::user()->ban == 1)
@include('errors.ban')
@php exit() @endphp
@endif
<!DOCTYPE html> 
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{$setting->name}}</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    {!! $setting->meta_tags !!}
    <!-- <link rel="icon" type="image/png" href="images/favicon.png" sizes="64x64" /> -->
    <!-- <meta name="msapplication-TileImage" content="images/favicon.png"> -->
    <link rel="apple-touch-icon" sizes="64x64" href="/images/favicon.png">
    <link rel="icon" sizes="64x64" href="/images/favicon.png">

    <link rel="stylesheet" href="/css/main.css?v={{time()}}">

    

    <script src="https://cdnjs.cloudflare.com/ajax/libs/socket.io/2.3.0/socket.io.js" crossorigin="anonymous"></script
    <script src="https://cdn.jsdelivr.net/npm/chart.js@3.5.1/dist/chart.min.js"></script>

    <script src="https://code.jquery.com/jquery-3.1.1.min.js" integrity="sha256-hVVnYaiADRTO2PzUGmuLJr8BLUSjGIZsDYGmIJLv2b8=" crossorigin="anonymous"></script>

    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/simple-scrollbar@latest/simple-scrollbar.css">
    <script src="https://cdn.jsdelivr.net/npm/simple-scrollbar@latest/simple-scrollbar.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
    <script src="/js/modal.js" type="text/javascript"></script>
    <script src="/js/ripple.js" type="text/javascript"></script>
    <link rel="stylesheet" href="css/ripple.css">
    <link rel="stylesheet" href="css/index.css">
    <script src="/js/countup.js?v={{time()}}" type="text/javascript"></script>


    <script
    src="https://hcaptcha.com/1/api.js?render=explicit"
    async
    defer
    ></script>

    <!-- <script async src="https://telegram.org/js/telegram-widget.js?21" data-telegram-login="betusxbot" data-size="large" data-auth-url="https://betusx.pro/tg/auth/callback" data-request-access="write"></script>
    <script src="https://telegram.org/js/widget-frame.js?60" data-telegram-login="betusxbot" data-size="large" data-auth-url="https://betusx.pro/tg/auth/callback" data-request-access="write"></script> -->

</head> 



<body class="theme--dark">

        <div class="preloader d-flex align-center justify-center">
        <div class="preloader__lift d-flex align-center justify-center">
            <div class="preloader__lift-container d-flex align-center justify-space-between">
                <div class="preloader__loader">
                    <svg width="220" height="163" viewBox="0 0 220 163" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M128.964 0.498828C119.205 1.86455 112.054 4.49845 96.1106 12.4977C86.5443 17.2777 74.8522 22.4479 70.0207 23.9112C62.0971 26.2524 59.8747 26.5451 45.3803 26.5451C30.3062 26.6426 29.05 26.4475 22.9624 24.0088C19.3871 22.5455 14.8455 20.3018 12.8163 18.8385L9.14438 16.3997L8.75787 18.5459C8.27472 21.9602 10.4972 30.9349 13.2028 36.3002C16.5848 43.0313 24.9916 51.7134 31.7556 55.3228C46.6365 63.322 62.0971 63.1269 77.0747 54.9326C80.36 53.0791 83.0657 51.9085 83.0657 52.3962C83.0657 54.0546 75.2387 63.322 71.5668 65.9559C69.5376 67.4192 66.1556 69.4678 63.9331 70.4433C60.6477 72.0041 59.778 72.8821 59.2949 75.7111C58.7151 78.8327 59.2949 88.6854 60.4544 96.392L61.0342 99.9038L53.787 103.513C43.0612 108.976 32.5286 111.317 21.6095 110.83C13.8792 110.537 11.85 110.049 5.95562 107.025C-0.615157 103.806 -0.808415 103.708 0.930909 106.147C4.2163 110.83 15.0388 120.585 21.7062 124.877C30.7893 130.828 39.4859 134.144 50.8882 136.095C59.2949 137.559 62.6769 137.559 81.1331 136.583C104.131 135.217 110.895 135.803 119.591 139.802C122.297 141.071 124.616 142.339 124.616 142.631C124.616 142.827 121.331 143.119 117.272 143.119C109.929 143.119 94.6612 146.533 94.6612 148.192C94.6612 149.753 112.538 157.849 120.751 159.996C131.863 162.825 147.904 162.825 158.92 159.898C191.58 151.216 214.964 124.584 219.409 91.1242C220.376 83.2225 220.182 75.0282 218.636 64.8828L218.057 61.2734H172.834L127.515 81.2044V81.2715V81.3386L174.96 101.27L173.221 104.294C170.515 108.976 163.461 114.927 156.504 118.244C150.609 121.073 149.45 121.268 139.594 121.268C130.027 121.268 128.385 120.975 123.36 118.634C116.113 115.219 111.088 111.122 106.933 105.367C95.2409 89.0756 96.4971 67.6143 110.122 53.0791C122.684 39.617 142.782 36.1051 158.34 44.6897L163.558 47.6162H188.198C216.027 47.6162 213.998 48.4942 208.394 39.0317C194.286 15.2291 166.553 -0.476692 139.594 0.0110659C135.342 0.0110659 130.607 0.303725 128.964 0.498828Z" fill="#526184"/>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    
 <div id="app">
        <div class="sidebar">
            <div class="logo">
                <a class="logoim" onclick="load('')" href='#'></a>
                <a class="gx-btn round aside right vert-center filled leftBtn swapon" href="#">
                    <svg class="icon sw1"><use xlink:href="/images/symbols.svg?v=31#arrow_left"></use></svg>
                    <svg class="icon sw2"><use xlink:href="/images/symbols.svg?v=31#arrow_right"></use></svg>
                </a>
            </div>
            <div class="tc-wrapper">
                <div class="inner">
                    <a class="item marked" onclick="load('tourniers')">
                        <div class="icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none">
                                <g clip-path="url(#clip0_215_46295)">
                                    <path d="M14.9133 3.52081L13.5201 3.1842C13.3905 3.15291 13.2773 3.07432 13.2026 2.96387L12.3995 1.77677C12.3024 1.63319 12.1536 1.55616 12.0004 1.54373C11.8473 1.55616 11.6985 1.63319 11.6013 1.77677L10.7983 2.96387C10.7235 3.07432 10.6103 3.15286 10.4807 3.1842L9.08758 3.52081C8.70969 3.61211 8.55219 4.06317 8.79111 4.36985L9.67195 5.50044C9.75388 5.60561 9.7936 5.73757 9.78334 5.87051L9.67299 7.29945C9.64306 7.68707 10.0233 7.9762 10.3888 7.84373L11.7363 7.3554C11.8214 7.32453 11.9122 7.31658 12.0004 7.33023C12.0885 7.31658 12.1793 7.32453 12.2645 7.3554L13.6119 7.84373C13.9774 7.9762 14.3577 7.68703 14.3278 7.29945L14.2174 5.87051C14.2072 5.73757 14.2469 5.60561 14.3288 5.50044L15.2096 4.36985C15.4486 4.06317 15.2912 3.61216 14.9133 3.52081Z" fill="url(#paint0_linear_215_46295)"/>
                                    <path d="M12.2641 7.35546L13.6116 7.84379C13.9771 7.97626 14.3574 7.68709 14.3274 7.29951L14.2171 5.87057C14.2068 5.73763 14.2465 5.60568 14.3285 5.5005L15.2093 4.36991C15.4482 4.06323 15.2907 3.61222 14.9128 3.52088L13.5197 3.18426C13.3901 3.15297 13.2769 3.07438 13.2022 2.96393L12.3991 1.77683C12.302 1.63325 12.1531 1.55622 12 1.54379V7.33029C12.0882 7.31664 12.179 7.32459 12.2641 7.35546Z" fill="url(#paint1_linear_215_46295)"/>
                                    <path d="M14.9134 3.52081L13.5202 3.1842C13.4727 3.17271 13.4274 3.15474 13.3853 3.13126L9.83398 7.72476C9.97328 7.8594 10.1834 7.91822 10.3889 7.84377L11.7364 7.35544C11.8215 7.32457 11.9123 7.31662 12.0005 7.33027C12.0886 7.31662 12.1794 7.32457 12.2646 7.35544L13.612 7.84377C13.9775 7.97624 14.3578 7.68707 14.3279 7.29949L14.2175 5.87055C14.2073 5.73761 14.247 5.60566 14.3289 5.50048L15.2097 4.36989C15.4487 4.06316 15.2913 3.61215 14.9134 3.52081Z" fill="url(#paint2_linear_215_46295)"/>
                                    <path d="M9.08753 3.52081L10.4807 3.1842C10.5282 3.17271 10.5735 3.15474 10.6156 3.13126L14.1669 7.72476C14.0276 7.8594 13.8175 7.91822 13.6119 7.84377L12.2645 7.35544C12.1794 7.32457 12.0886 7.31662 12.0004 7.33027C11.9123 7.31662 11.8215 7.32457 11.7363 7.35544L10.3889 7.84377C10.0234 7.97624 9.6431 7.68707 9.67303 7.29949L9.78339 5.87055C9.79364 5.73761 9.75393 5.60566 9.672 5.50048L8.79115 4.36989C8.55219 4.06316 8.70964 3.61215 9.08753 3.52081Z" fill="url(#paint3_linear_215_46295)"/>
                                    <path d="M8.71719 3.84363C8.65093 4.01069 8.66684 4.20975 8.79154 4.36984L9.67239 5.50043C9.75432 5.6056 9.79404 5.73756 9.78378 5.8705L9.67343 7.29944C9.6435 7.68706 10.0238 7.97619 10.3893 7.84372L11.7367 7.35539C11.8218 7.32452 11.9127 7.31657 12.0008 7.33022C12.089 7.31657 12.1798 7.32452 12.2649 7.35539L13.6123 7.84372C13.9778 7.97619 14.3581 7.68702 14.3282 7.29944L14.2179 5.8705C14.2122 5.79676 14.2224 5.72344 14.2461 5.65469L8.71719 3.84363Z" fill="url(#paint4_linear_215_46295)"/>
                                    <path d="M15.2845 3.84363C15.3508 4.01069 15.3349 4.20975 15.2102 4.36984L14.3293 5.50043C14.2474 5.6056 14.2077 5.73756 14.218 5.8705L14.3283 7.29944C14.3582 7.68706 13.978 7.97619 13.6125 7.84372L12.265 7.35539C12.1799 7.32452 12.0891 7.31657 12.0009 7.33022C11.9128 7.31657 11.822 7.32452 11.7368 7.35539L10.3894 7.84372C10.0239 7.97619 9.6436 7.68702 9.67353 7.29944L9.78389 5.8705C9.78958 5.79676 9.77937 5.72344 9.7556 5.65469L15.2845 3.84363Z" fill="url(#paint5_linear_215_46295)"/>
                                    <path d="M14.7674 4.93753H9.2334L9.67199 5.50045C9.75392 5.60562 9.79363 5.73758 9.78337 5.87052L9.67302 7.29946C9.64309 7.68708 10.0234 7.97621 10.3889 7.84374L11.7363 7.35541C11.8214 7.32454 11.9123 7.31659 12.0004 7.33024C12.0886 7.31659 12.1794 7.32454 12.2645 7.35541L13.6119 7.84374C13.9774 7.97621 14.3577 7.68704 14.3278 7.29946L14.2174 5.87052C14.2072 5.73758 14.2469 5.60562 14.3288 5.50045L14.7674 4.93753Z" fill="url(#paint6_linear_215_46295)"/>
                                    <path d="M8.39765 5.76546L7.33704 5.50918C7.23835 5.48532 7.15214 5.42551 7.0953 5.34146L6.48386 4.4377C6.40988 4.32838 6.29661 4.26974 6.18 4.26028C6.06344 4.26974 5.95012 4.32838 5.87614 4.4377L5.26475 5.34146C5.20786 5.42551 5.12165 5.48537 5.02301 5.50918L3.9624 5.76546C3.67468 5.83497 3.55483 6.17836 3.73671 6.41186L4.4073 7.27261C4.4697 7.35271 4.49991 7.45318 4.4921 7.55436L4.40805 8.64226C4.38527 8.93737 4.67478 9.15751 4.95304 9.05666L5.97892 8.68485C6.04372 8.66137 6.11285 8.6553 6.18 8.6657C6.24711 8.6553 6.31624 8.66137 6.38108 8.68485L7.40697 9.05666C7.68523 9.15751 7.97478 8.93737 7.95195 8.64226L7.86791 7.55436C7.8601 7.45313 7.89036 7.35266 7.95271 7.27261L8.6233 6.41186C8.80523 6.1784 8.68532 5.83497 8.39765 5.76546Z" fill="url(#paint7_linear_215_46295)"/>
                                    <path d="M6.38077 8.6849L7.40665 9.05671C7.68491 9.15756 7.97446 8.93741 7.95164 8.64231L7.86759 7.5544C7.85978 7.45318 7.89004 7.35271 7.95239 7.27266L8.62298 6.41191C8.80486 6.17845 8.68496 5.83501 8.39729 5.76551L7.33668 5.50923C7.23799 5.48537 7.15178 5.42556 7.09493 5.34151L6.48355 4.4377C6.40957 4.32838 6.2963 4.26974 6.17969 4.26028V8.66574C6.24684 8.65534 6.31597 8.66141 6.38077 8.6849Z" fill="url(#paint8_linear_215_46295)"/>
                                    <path d="M8.39733 5.76547L7.33672 5.50919C7.30053 5.50043 7.26604 5.48674 7.23399 5.4689L4.53027 8.96608C4.63634 9.06857 4.79634 9.11337 4.95281 9.05667L5.9787 8.68486C6.0435 8.66137 6.11263 8.6553 6.17978 8.6657C6.24689 8.6553 6.31601 8.66137 6.38086 8.68486L7.40674 9.05667C7.685 9.15751 7.97456 8.93737 7.95173 8.64227L7.86769 7.55436C7.85987 7.45314 7.89013 7.35267 7.95249 7.27262L8.62307 6.41187C8.80491 6.17841 8.685 5.83497 8.39733 5.76547Z" fill="url(#paint9_linear_215_46295)"/>
                                    <path d="M3.96244 5.76547L5.02305 5.50919C5.05924 5.50043 5.09373 5.48674 5.12578 5.4689L7.8295 8.96608C7.72343 9.06857 7.56343 9.11337 7.40695 9.05667L6.38107 8.68486C6.31627 8.66137 6.24714 8.6553 6.17999 8.6657C6.11288 8.6553 6.04375 8.66137 5.97891 8.68486L4.95303 9.05667C4.67477 9.15751 4.38521 8.93737 4.40804 8.64227L4.49208 7.55436C4.4999 7.45314 4.46964 7.35267 4.40728 7.27262L3.7367 6.41187C3.55481 6.17841 3.67472 5.83497 3.96244 5.76547Z" fill="url(#paint10_linear_215_46295)"/>
                                    <path d="M3.67969 6.01126C3.62924 6.13846 3.64134 6.28999 3.7363 6.41187L4.40689 7.27263C4.46929 7.35272 4.4995 7.45319 4.49169 7.55437L4.40764 8.64227C4.38487 8.93738 4.67437 9.15752 4.95263 9.05667L5.97852 8.68486C6.04332 8.66138 6.11244 8.65531 6.1796 8.66571C6.2467 8.65531 6.31583 8.66138 6.38068 8.68486L7.40656 9.05667C7.68482 9.15752 7.97437 8.93738 7.95155 8.64227L7.8675 7.55437C7.86317 7.49823 7.87094 7.44241 7.88906 7.39008L3.67969 6.01126Z" fill="url(#paint11_linear_215_46295)"/>
                                    <path d="M8.68035 6.01126C8.7308 6.13846 8.71871 6.28999 8.62374 6.41187L7.95315 7.27263C7.89075 7.35272 7.86054 7.45319 7.86835 7.55437L7.9524 8.64227C7.97518 8.93738 7.68567 9.15752 7.40741 9.05667L6.38153 8.68486C6.31673 8.66138 6.2476 8.65531 6.18045 8.66571C6.11334 8.65531 6.04421 8.66138 5.97936 8.68486L4.95348 9.05667C4.67522 9.15752 4.38567 8.93738 4.40849 8.64227L4.49254 7.55437C4.49687 7.49823 4.48911 7.44241 4.47099 7.39008L8.68035 6.01126Z" fill="url(#paint12_linear_215_46295)"/>
                                    <path d="M8.28647 6.84406H4.07324L4.40712 7.27262C4.46952 7.35271 4.49974 7.45318 4.49192 7.55436L4.40788 8.64227C4.3851 8.93737 4.67461 9.15751 4.95287 9.05667L5.97875 8.68485C6.04355 8.66137 6.11268 8.6553 6.17983 8.6657C6.24694 8.6553 6.31607 8.66137 6.38091 8.68485L7.4068 9.05667C7.68505 9.15751 7.97461 8.93737 7.95178 8.64227L7.86774 7.55436C7.85992 7.45314 7.89018 7.35267 7.95254 7.27262L8.28647 6.84406Z" fill="url(#paint13_linear_215_46295)"/>
                                    <path d="M20.0372 5.76546L18.9766 5.50918C18.878 5.48532 18.7917 5.42551 18.7349 5.34146L18.1235 4.4377C18.0495 4.32838 17.9363 4.26974 17.8196 4.26028C17.7031 4.26974 17.5898 4.32838 17.5158 4.4377L16.9044 5.34146C16.8475 5.42551 16.7613 5.48537 16.6627 5.50918L15.602 5.76546C15.3143 5.83497 15.1945 6.17836 15.3764 6.41186L16.0469 7.27261C16.1093 7.35271 16.1396 7.45318 16.1317 7.55436L16.0477 8.64226C16.0249 8.93737 16.3144 9.15751 16.5927 9.05666L17.6185 8.68485C17.6833 8.66137 17.7524 8.6553 17.8196 8.6657C17.8867 8.6553 17.9558 8.66137 18.0207 8.68485L19.0466 9.05666C19.3248 9.15751 19.6144 8.93737 19.5916 8.64226L19.5075 7.55436C19.4997 7.45313 19.53 7.35266 19.5923 7.27261L20.2629 6.41186C20.4449 6.1784 20.325 5.83497 20.0372 5.76546Z" fill="url(#paint14_linear_215_46295)"/>
                                    <path d="M18.0204 8.68491L19.0463 9.05672C19.3246 9.15757 19.6141 8.93743 19.5913 8.64232L19.5072 7.55442C19.4994 7.45319 19.5297 7.35272 19.592 7.27268L20.2626 6.41192C20.4445 6.17846 20.3246 5.83503 20.0369 5.76552L18.9763 5.50924C18.8776 5.48538 18.7914 5.42557 18.7346 5.34152L18.1232 4.43776C18.0492 4.32844 17.9359 4.2698 17.8193 4.26035V8.6658C17.8865 8.65536 17.9556 8.66143 18.0204 8.68491Z" fill="url(#paint15_linear_215_46295)"/>
                                    <path d="M20.037 5.76547L18.9764 5.50919C18.9402 5.50043 18.9057 5.48674 18.8736 5.4689L16.1699 8.96608C16.276 9.06857 16.436 9.11337 16.5925 9.05667L17.6183 8.68486C17.6831 8.66137 17.7522 8.6553 17.8194 8.6657C17.8865 8.6553 17.9556 8.66137 18.0205 8.68486L19.0463 9.05667C19.3246 9.15751 19.6142 8.93737 19.5913 8.64227L19.5073 7.55436C19.4995 7.45314 19.5297 7.35267 19.5921 7.27262L20.2627 6.41187C20.4446 6.17841 20.3247 5.83497 20.037 5.76547Z" fill="url(#paint16_linear_215_46295)"/>
                                    <path d="M15.602 5.76547L16.6627 5.50919C16.6988 5.50043 16.7333 5.48674 16.7654 5.4689L19.4691 8.96608C19.363 9.06857 19.203 9.11337 19.0466 9.05667L18.0207 8.68486C17.9559 8.66137 17.8867 8.6553 17.8196 8.6657C17.7525 8.6553 17.6834 8.66137 17.6185 8.68486L16.5927 9.05667C16.3144 9.15751 16.0249 8.93737 16.0477 8.64227L16.1317 7.55436C16.1395 7.45314 16.1093 7.35267 16.0469 7.27262L15.3763 6.41187C15.1945 6.17841 15.3144 5.83497 15.602 5.76547Z" fill="url(#paint17_linear_215_46295)"/>
                                    <path d="M15.3193 6.01126C15.2689 6.13846 15.281 6.28999 15.376 6.41187L16.0465 7.27263C16.1089 7.35272 16.1392 7.45319 16.1313 7.55437L16.0473 8.64227C16.0245 8.93738 16.314 9.15752 16.5923 9.05667L17.6181 8.68486C17.6829 8.66138 17.752 8.65531 17.8192 8.66571C17.8863 8.65531 17.9554 8.66138 18.0203 8.68486L19.0462 9.05667C19.3244 9.15752 19.614 8.93738 19.5912 8.64227L19.5071 7.55437C19.5028 7.49823 19.5105 7.44241 19.5287 7.39008L15.3193 6.01126Z" fill="url(#paint18_linear_215_46295)"/>
                                    <path d="M20.3199 6.01126C20.3704 6.13846 20.3583 6.28999 20.2633 6.41187L19.5927 7.27263C19.5303 7.35272 19.5001 7.45319 19.5079 7.55437L19.592 8.64227C19.6147 8.93738 19.3252 9.15752 19.047 9.05667L18.0211 8.68486C17.9563 8.66138 17.8872 8.65531 17.82 8.66571C17.7529 8.65531 17.6838 8.66138 17.619 8.68486L16.5931 9.05667C16.3149 9.15752 16.0253 8.93738 16.0481 8.64227L16.1322 7.55437C16.1365 7.49823 16.1288 7.44241 16.1106 7.39008L20.3199 6.01126Z" fill="url(#paint19_linear_215_46295)"/>
                                    <path d="M19.9261 6.84406H15.7129L16.0468 7.27262C16.1092 7.35271 16.1394 7.45318 16.1316 7.55436L16.0475 8.64227C16.0247 8.93737 16.3143 9.15751 16.5925 9.05667L17.6184 8.68485C17.6832 8.66137 17.7523 8.6553 17.8195 8.6657C17.8866 8.6553 17.9557 8.66137 18.0206 8.68485L19.0464 9.05667C19.3247 9.15751 19.6143 8.93737 19.5914 8.64227L19.5074 7.55436C19.4996 7.45314 19.5298 7.35267 19.5922 7.27262L19.9261 6.84406Z" fill="url(#paint20_linear_215_46295)"/>
                                    <path d="M1.26419 10.11C0.565977 10.11 0 10.6759 0 11.3741C0 11.5708 0.0458824 11.7648 0.134024 11.9406L1.70207 15.0689C1.93402 15.5316 1.93402 16.0766 1.70207 16.5393L0.134024 19.6675C0.0458824 19.8433 0 20.0373 0 20.234C0 20.9322 0.565977 21.4982 1.26419 21.4982H12V10.11H1.26419Z" fill="url(#paint21_linear_215_46295)"/>
                                    <path d="M2.54102 13.3099H7.99984V18.2982H2.54102V13.3099Z" fill="url(#paint22_linear_215_46295)"/>
                                    <path d="M1.27454 17.3922L0.134071 19.6675C0.0458824 19.8433 0 20.0373 0 20.234C0 20.9322 0.565977 21.4982 1.26419 21.4982H12V17.3922H1.27454Z" fill="url(#paint23_linear_215_46295)"/>
                                    <path d="M1.27454 17.3922L0.134071 19.6675C0.0458824 19.8433 0 20.0373 0 20.234C0 20.9322 0.565977 21.4982 1.26419 21.4982H12V17.3922H1.27454Z" fill="url(#paint24_linear_215_46295)"/>
                                    <path d="M1.27454 14.2159H12V10.1099H1.26419C0.565977 10.1099 0 10.6759 0 11.3741C0 11.5708 0.0458824 11.7648 0.134024 11.9406L1.27454 14.2159Z" fill="url(#paint25_linear_215_46295)"/>
                                    <path d="M1.27454 14.2159H12V10.1099H1.26419C0.565977 10.1099 0 10.6759 0 11.3741C0 11.5708 0.0458824 11.7648 0.134024 11.9406L1.27454 14.2159Z" fill="url(#paint26_linear_215_46295)"/>
                                    <path d="M22.7358 10.11C23.434 10.11 24 10.6759 24 11.3741C24 11.5708 23.9541 11.7648 23.866 11.9406L22.2979 15.0689C22.066 15.5316 22.066 16.0766 22.2979 16.5393L23.866 19.6676C23.9541 19.8434 24 20.0373 24 20.234C24 20.9323 23.434 21.4982 22.7358 21.4982H12V10.11H22.7358V10.11Z" fill="url(#paint27_linear_215_46295)"/>
                                    <path d="M16 18.2982H21.4588V13.3099H16V18.2982Z" fill="url(#paint28_linear_215_46295)"/>
                                    <path d="M22.7255 17.3922L23.8659 19.6675C23.9541 19.8433 24 20.0373 24 20.234C24 20.9322 23.434 21.4982 22.7358 21.4982H12V17.3922H22.7255Z" fill="url(#paint29_linear_215_46295)"/>
                                    <path d="M22.7255 17.3922L23.8659 19.6675C23.9541 19.8433 24 20.0373 24 20.234C24 20.9322 23.434 21.4982 22.7358 21.4982H12V17.3922H22.7255Z" fill="url(#paint30_linear_215_46295)"/>
                                    <path d="M22.7255 14.2159H12V10.1099H22.7358C23.434 10.1099 24 10.6759 24 11.3741C24 11.5708 23.9541 11.7648 23.866 11.9406L22.7255 14.2159Z" fill="url(#paint31_linear_215_46295)"/>
                                    <path d="M22.7255 14.2159H12V10.1099H22.7358C23.434 10.1099 24 10.6759 24 11.3741C24 11.5708 23.9541 11.7648 23.866 11.9406L22.7255 14.2159Z" fill="url(#paint32_linear_215_46295)"/>
                                    <path d="M12.7518 9.4746C13.319 8.87968 14.3197 9.14782 14.5134 9.9466C14.6532 10.5231 15.2466 10.8657 15.8158 10.6985C16.6045 10.4669 17.337 11.1995 17.1054 11.9881C16.9382 12.5573 17.2808 13.1507 17.8573 13.2905C18.6561 13.4842 18.9242 14.4849 18.3293 15.0521C17.9 15.4615 17.9 16.1466 18.3293 16.556C18.9242 17.1232 18.6561 18.1239 17.8573 18.3176C17.2808 18.4574 16.9382 19.0508 17.1054 19.62C17.337 20.4087 16.6044 21.1412 15.8158 20.9096C15.2466 20.7424 14.6532 21.085 14.5134 21.6615C14.3197 22.4603 13.319 22.7284 12.7518 22.1335C12.3424 21.7041 11.6573 21.7041 11.2479 22.1335C10.6808 22.7284 9.68005 22.4603 9.4863 21.6615C9.34649 21.085 8.75308 20.7424 8.1839 20.9096C7.39524 21.1412 6.66273 20.4086 6.89435 19.62C7.06155 19.0508 6.71892 18.4574 6.1424 18.3176C5.34362 18.1239 5.07548 17.1232 5.6704 16.556C6.09976 16.1466 6.09976 15.4615 5.6704 15.0521C5.07548 14.4849 5.34362 13.4842 6.1424 13.2905C6.71892 13.1507 7.0615 12.5573 6.89435 11.9881C6.66273 11.1994 7.39529 10.4669 8.1839 10.6985C8.75308 10.8657 9.34649 10.5231 9.4863 9.9466C9.68005 9.14782 10.6807 8.87968 11.2479 9.4746C11.6573 9.90396 12.3424 9.90396 12.7518 9.4746Z" fill="url(#paint33_linear_215_46295)"/>
                                    <path d="M11.9995 21.1063C14.9279 21.1063 17.3018 18.7324 17.3018 15.8041C17.3018 12.8757 14.9279 10.5018 11.9995 10.5018C9.07117 10.5018 6.69727 12.8757 6.69727 15.8041C6.69727 18.7324 9.07117 21.1063 11.9995 21.1063Z" fill="url(#paint34_linear_215_46295)"/>
                                    <path d="M12.0003 20.3561C14.5143 20.3561 16.5523 18.3181 16.5523 15.8041C16.5523 13.29 14.5143 11.252 12.0003 11.252C9.48626 11.252 7.44824 13.29 7.44824 15.8041C7.44824 18.3181 9.48626 20.3561 12.0003 20.3561Z" fill="url(#paint35_linear_215_46295)"/>
                                    <path d="M5.98866 15.7268C6.01077 16.0256 5.90532 16.3321 5.6704 16.556C5.07548 17.1232 5.34362 18.1239 6.1424 18.3176C6.71892 18.4574 7.0615 19.0508 6.89435 19.62C6.66273 20.4087 7.39529 21.1412 8.1839 20.9096C8.75308 20.7424 9.34649 21.085 9.4863 21.6615C9.68005 22.4603 10.6807 22.7284 11.2479 22.1335C11.6573 21.7042 12.3424 21.7042 12.7518 22.1335C13.319 22.7284 14.3197 22.4603 14.5134 21.6615C14.6532 21.085 15.2466 20.7424 15.8158 20.9096C16.6045 21.1412 17.337 20.4086 17.1054 19.62C16.9382 19.0508 17.2808 18.4574 17.8573 18.3176C18.6561 18.1239 18.9242 17.1232 18.3293 16.556C18.0944 16.3321 17.9889 16.0256 18.0111 15.7268H5.98866Z" fill="url(#paint36_linear_215_46295)"/>
                                    <path d="M14.5004 14.7088L13.9065 14.7379L12.3039 13.1353L10.3506 17.6636L14.4744 21.7874C14.4896 21.7469 14.503 21.7051 14.5136 21.6615C14.6534 21.0849 15.2468 20.7424 15.816 20.9095C16.6047 21.1411 17.3372 20.4086 17.1056 19.62C16.9384 19.0508 17.281 18.4574 17.8575 18.3176C17.9237 18.3015 17.9859 18.2794 18.0446 18.253L14.5004 14.7088Z" fill="url(#paint37_linear_215_46295)"/>
                                    <path d="M14.2179 14.4631L13.1573 14.2068C13.0586 14.1829 12.9724 14.1231 12.9156 14.0391L12.3042 13.1353C12.2302 13.026 12.1169 12.9673 12.0003 12.9579C11.8838 12.9673 11.7704 13.026 11.6965 13.1353L11.0851 14.0391C11.0282 14.1231 10.942 14.183 10.8433 14.2068L9.78271 14.4631C9.495 14.5326 9.37514 14.876 9.55702 15.1095L10.2276 15.9702C10.29 16.0503 10.3202 16.1508 10.3124 16.252L10.2284 17.3399C10.2056 17.635 10.4951 17.8551 10.7733 17.7543L11.7992 17.3825C11.864 17.359 11.9331 17.3529 12.0003 17.3633C12.0674 17.3529 12.1365 17.359 12.2014 17.3825L13.2272 17.7543C13.5054 17.8551 13.795 17.635 13.7722 17.3399L13.6881 16.252C13.6803 16.1507 13.7106 16.0503 13.7729 15.9702L14.4435 15.1095C14.6255 14.876 14.5056 14.5326 14.2179 14.4631Z" fill="url(#paint38_linear_215_46295)"/>
                                    <path d="M12.2011 17.3825L13.227 17.7543C13.5052 17.8551 13.7948 17.635 13.772 17.3399L13.6879 16.252C13.6801 16.1507 13.7104 16.0503 13.7727 15.9702L14.4433 15.1095C14.6252 14.876 14.5053 14.5326 14.2176 14.4631L13.157 14.2068C13.0583 14.1829 12.9721 14.1231 12.9152 14.0391L12.3039 13.1353C12.2299 13.026 12.1166 12.9673 12 12.9579V17.3633C12.0672 17.3529 12.1363 17.359 12.2011 17.3825Z" fill="url(#paint39_linear_215_46295)"/>
                                    <path d="M14.2176 14.4631L13.157 14.2068C13.1208 14.198 13.0864 14.1843 13.0543 14.1665L10.3506 17.6637C10.4567 17.7662 10.6167 17.811 10.7731 17.7543L11.799 17.3825C11.8638 17.359 11.9329 17.3529 12 17.3633C12.0672 17.3529 12.1363 17.359 12.2011 17.3825L13.227 17.7543C13.5052 17.8551 13.7948 17.635 13.772 17.3399L13.6879 16.252C13.6801 16.1507 13.7104 16.0503 13.7727 15.9702L14.4433 15.1095C14.6252 14.876 14.5053 14.5326 14.2176 14.4631Z" fill="url(#paint40_linear_215_46295)"/>
                                    <path d="M9.78269 14.4631L10.8433 14.2068C10.8795 14.198 10.914 14.1843 10.946 14.1665L13.6497 17.6637C13.5437 17.7662 13.3837 17.811 13.2272 17.7543L12.2014 17.3825C12.1366 17.359 12.0674 17.3529 12.0003 17.3633C11.9332 17.3529 11.8641 17.359 11.7992 17.3825L10.7734 17.7543C10.4951 17.8551 10.2056 17.635 10.2284 17.3399L10.3124 16.252C10.3202 16.1507 10.29 16.0503 10.2276 15.9702L9.55704 15.1095C9.37511 14.876 9.49502 14.5326 9.78269 14.4631Z" fill="url(#paint41_linear_215_46295)"/>
                                    <path d="M9.5 14.7088C9.44956 14.836 9.46165 14.9875 9.55662 15.1094L10.2272 15.9702C10.2896 16.0503 10.3198 16.1507 10.312 16.2519L10.228 17.3398C10.2052 17.6349 10.4947 17.8551 10.7729 17.7542L11.7988 17.3824C11.8636 17.3589 11.9327 17.3528 11.9999 17.3632C12.067 17.3528 12.1361 17.3589 12.2009 17.3824L13.2268 17.7542C13.505 17.8551 13.7946 17.6349 13.7718 17.3398L13.6877 16.2519C13.6834 16.1958 13.6912 16.14 13.7093 16.0876L9.5 14.7088Z" fill="url(#paint42_linear_215_46295)"/>
                                    <path d="M14.5006 14.7088C14.551 14.836 14.5389 14.9875 14.444 15.1094L13.7734 15.9702C13.711 16.0503 13.6808 16.1507 13.6886 16.2519L13.7726 17.3398C13.7954 17.6349 13.5059 17.8551 13.2276 17.7542L12.2018 17.3824C12.137 17.3589 12.0679 17.3528 12.0007 17.3632C11.9336 17.3528 11.8645 17.3589 11.7996 17.3824L10.7738 17.7542C10.4955 17.8551 10.206 17.6349 10.2288 17.3398L10.3129 16.2519C10.3172 16.1958 10.3094 16.14 10.2913 16.0876L14.5006 14.7088Z" fill="url(#paint43_linear_215_46295)"/>
                                </g>
                                <defs>
                                    <linearGradient id="paint0_linear_215_46295" x1="10.5207" y1="3.71418" x2="13.1891" y2="6.38256" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#FEF0AE"/>
                                    <stop offset="1" stop-color="#FBC56D"/>
                                    </linearGradient>
                                    <linearGradient id="paint1_linear_215_46295" x1="13.5989" y1="4.44172" x2="9.91087" y2="5.96643" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint2_linear_215_46295" x1="12.6364" y1="5.7505" x2="10.6173" y2="4.88514" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint3_linear_215_46295" x1="11.3645" y1="5.7505" x2="13.3836" y2="4.88514" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint4_linear_215_46295" x1="11.4098" y1="5.85182" x2="12.7078" y2="3.76565" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint5_linear_215_46295" x1="12.4918" y1="5.58833" x2="12.3837" y2="3.54857" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint6_linear_215_46295" x1="12.0004" y1="6.08972" x2="12.0004" y2="8.35621" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#DC8758" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#DC8758" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#DC8758"/>
                                    </linearGradient>
                                    <linearGradient id="paint7_linear_215_46295" x1="5.05346" y1="5.91266" x2="7.08499" y2="7.94419" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#FEF0AE"/>
                                    <stop offset="1" stop-color="#FBC56D"/>
                                    </linearGradient>
                                    <linearGradient id="paint8_linear_215_46295" x1="7.39696" y1="6.46659" x2="4.58915" y2="7.62734" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint9_linear_215_46295" x1="6.66383" y1="7.46302" x2="5.1266" y2="6.8042" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint10_linear_215_46295" x1="5.6959" y1="7.46302" x2="7.23317" y2="6.8042" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint11_linear_215_46295" x1="5.72962" y1="7.54011" x2="6.7179" y2="5.95187" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint12_linear_215_46295" x1="6.55419" y1="7.33954" x2="6.47183" y2="5.7866" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint13_linear_215_46295" x1="6.17983" y1="7.72128" x2="6.17983" y2="9.44678" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#DC8758" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#DC8758" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#DC8758"/>
                                    </linearGradient>
                                    <linearGradient id="paint14_linear_215_46295" x1="16.6931" y1="5.91266" x2="18.7246" y2="7.94419" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#FEF0AE"/>
                                    <stop offset="1" stop-color="#FBC56D"/>
                                    </linearGradient>
                                    <linearGradient id="paint15_linear_215_46295" x1="19.0367" y1="6.4666" x2="16.2288" y2="7.62736" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint16_linear_215_46295" x1="18.3035" y1="7.46302" x2="16.7663" y2="6.8042" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint17_linear_215_46295" x1="17.3355" y1="7.46302" x2="18.8728" y2="6.8042" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint18_linear_215_46295" x1="17.3693" y1="7.54011" x2="18.3576" y2="5.95187" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint19_linear_215_46295" x1="18.1937" y1="7.33954" x2="18.1114" y2="5.7866" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F6A96C" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#F6A96C" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#F6A96C"/>
                                    </linearGradient>
                                    <linearGradient id="paint20_linear_215_46295" x1="17.8195" y1="7.72128" x2="17.8195" y2="9.44678" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#DC8758" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#DC8758" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#DC8758"/>
                                    </linearGradient>
                                    <linearGradient id="paint21_linear_215_46295" x1="3.14532" y1="13.5575" x2="6.11002" y2="15.581" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F9F5F3"/>
                                    <stop offset="1" stop-color="#D8E8F0"/>
                                    </linearGradient>
                                    <linearGradient id="paint22_linear_215_46295" x1="4.14102" y1="15.8041" x2="6.16511" y2="15.8041" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#678D98" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#678D98" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#678D98"/>
                                    </linearGradient>
                                    <linearGradient id="paint23_linear_215_46295" x1="3.29826" y1="16.4803" x2="7.11002" y2="20.1508" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#FD4755"/>
                                    <stop offset="1" stop-color="#A72B2B"/>
                                    </linearGradient>
                                    <linearGradient id="paint24_linear_215_46295" x1="3.76673" y1="20.5934" x2="7.37459" y2="19.1503" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#A72B2B" stop-opacity="0"/>
                                    <stop offset="1" stop-color="#42210B"/>
                                    </linearGradient>
                                    <linearGradient id="paint25_linear_215_46295" x1="4.06908" y1="9.53356" x2="8.02202" y2="13.5806" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#B3DAFE"/>
                                    <stop offset="1" stop-color="#0182FC"/>
                                    </linearGradient>
                                    <linearGradient id="paint26_linear_215_46295" x1="5.31991" y1="10.7774" x2="7.13953" y2="12.6911" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#0182FC" stop-opacity="0"/>
                                    <stop offset="0.1877" stop-color="#0181F8" stop-opacity="0.188"/>
                                    <stop offset="0.351" stop-color="#017DEE" stop-opacity="0.351"/>
                                    <stop offset="0.5052" stop-color="#0176DC" stop-opacity="0.505"/>
                                    <stop offset="0.6539" stop-color="#016DC3" stop-opacity="0.654"/>
                                    <stop offset="0.7986" stop-color="#0261A2" stop-opacity="0.799"/>
                                    <stop offset="0.9384" stop-color="#02537B" stop-opacity="0.938"/>
                                    <stop offset="1" stop-color="#024C67"/>
                                    </linearGradient>
                                    <linearGradient id="paint27_linear_215_46295" x1="20.8547" y1="13.5575" x2="17.89" y2="15.581" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#F9F5F3"/>
                                    <stop offset="1" stop-color="#D8E8F0"/>
                                    </linearGradient>
                                    <linearGradient id="paint28_linear_215_46295" x1="19.8588" y1="15.8041" x2="17.8347" y2="15.8041" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#678D98" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#678D98" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#678D98"/>
                                    </linearGradient>
                                    <linearGradient id="paint29_linear_215_46295" x1="20.7017" y1="16.4803" x2="16.89" y2="20.1508" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#FD4755"/>
                                    <stop offset="1" stop-color="#A72B2B"/>
                                    </linearGradient>
                                    <linearGradient id="paint30_linear_215_46295" x1="20.2333" y1="20.5934" x2="16.6255" y2="19.1503" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#A72B2B" stop-opacity="0"/>
                                    <stop offset="1" stop-color="#42210B"/>
                                    </linearGradient>
                                    <linearGradient id="paint31_linear_215_46295" x1="19.9309" y1="9.53356" x2="15.978" y2="13.5806" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#B3DAFE"/>
                                    <stop offset="1" stop-color="#0182FC"/>
                                    </linearGradient>
                                    <linearGradient id="paint32_linear_215_46295" x1="18.6801" y1="10.7774" x2="16.8605" y2="12.6911" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#0182FC" stop-opacity="0"/>
                                    <stop offset="0.1877" stop-color="#0181F8" stop-opacity="0.188"/>
                                    <stop offset="0.351" stop-color="#017DEE" stop-opacity="0.351"/>
                                    <stop offset="0.5052" stop-color="#0176DC" stop-opacity="0.505"/>
                                    <stop offset="0.6539" stop-color="#016DC3" stop-opacity="0.654"/>
                                    <stop offset="0.7986" stop-color="#0261A2" stop-opacity="0.799"/>
                                    <stop offset="0.9384" stop-color="#02537B" stop-opacity="0.938"/>
                                    <stop offset="1" stop-color="#024C67"/>
                                    </linearGradient>
                                    <linearGradient id="paint33_linear_215_46295" x1="7.55341" y1="11.3576" x2="16.0421" y2="19.8463" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#FEF0AE"/>
                                    <stop offset="1" stop-color="#FBC56D"/>
                                    </linearGradient>
                                    <linearGradient id="paint34_linear_215_46295" x1="15.4433" y1="19.2478" x2="8.45524" y2="12.2598" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#FEF0AE"/>
                                    <stop offset="1" stop-color="#FBC56D"/>
                                    </linearGradient>
                                    <linearGradient id="paint35_linear_215_46295" x1="8.69111" y1="12.4948" x2="14.1382" y2="17.9419" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#FEF0AE"/>
                                    <stop offset="1" stop-color="#FBC56D"/>
                                    </linearGradient>
                                    <linearGradient id="paint36_linear_215_46295" x1="11.9999" y1="18.4327" x2="11.9999" y2="21.97" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#DC8758" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#DC8758" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#DC8758"/>
                                    </linearGradient>
                                    <linearGradient id="paint37_linear_215_46295" x1="16.1171" y1="19.4289" x2="10.5641" y2="15.4054" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#DC8758" stop-opacity="0"/>
                                    <stop offset="0.9957" stop-color="#DC8758" stop-opacity="0.996"/>
                                    <stop offset="1" stop-color="#DC8758"/>
                                    </linearGradient>
                                    <linearGradient id="paint38_linear_215_46295" x1="10.8737" y1="14.6103" x2="12.9052" y2="16.6417" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#FBC56D"/>
                                    <stop offset="1" stop-color="#C5715A"/>
                                    </linearGradient>
                                    <linearGradient id="paint39_linear_215_46295" x1="13.2173" y1="15.1641" x2="10.4095" y2="16.3249" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#8C3D27" stop-opacity="0"/>
                                    <stop offset="1" stop-color="#8C3D27"/>
                                    </linearGradient>
                                    <linearGradient id="paint40_linear_215_46295" x1="12.4841" y1="16.1606" x2="10.9469" y2="15.5018" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#8C3D27" stop-opacity="0"/>
                                    <stop offset="1" stop-color="#8C3D27"/>
                                    </linearGradient>
                                    <linearGradient id="paint41_linear_215_46295" x1="11.5162" y1="16.1606" x2="13.0535" y2="15.5018" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#8C3D27" stop-opacity="0"/>
                                    <stop offset="1" stop-color="#8C3D27"/>
                                    </linearGradient>
                                    <linearGradient id="paint42_linear_215_46295" x1="11.5499" y1="16.2377" x2="12.5382" y2="14.6495" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#8C3D27" stop-opacity="0"/>
                                    <stop offset="1" stop-color="#8C3D27"/>
                                    </linearGradient>
                                    <linearGradient id="paint43_linear_215_46295" x1="12.3745" y1="16.0371" x2="12.2921" y2="14.4842" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#8C3D27" stop-opacity="0"/>
                                    <stop offset="1" stop-color="#8C3D27"/>
                                    </linearGradient>
                                    <clipPath id="clip0_215_46295">
                                    <rect width="24" height="24" fill="white"/>
                                    </clipPath>
                                </defs>
                            </svg>
                        </div>
                        <div class="title">Турниры</div>
                        <div class="go"><svg class="icon"><use xlink:href="/images/symbols.svg?v=21#arrow_right"></use></svg></div>
                    </a>
                    <a class="item sidebar__game game_shoot" onclick="load('shoot')">
                        <div class="icon"><svg class="icon"><use xlink:href="/images/symbols.svg?v=21#shoot"></use></svg></div>
                        <div class="title">Shoot</div>
                        <div class="tooltip">Shoot</div>
                    </a>
                    <a class="item sidebar__game game_crash" onclick="load('crash')">
                        <div class="icon"><svg class="icon"><use xlink:href="/images/symbols.svg?v=21#crash"></use></svg></div>
                        <div class="title">Crash</div>
                        <div class="tooltip">Crash</div>
                    </a>
                    <a class="item sidebar__game game_dice" onclick="load('dice')">
                        <div class="icon"><svg class="icon"><use xlink:href="/images/symbols.svg?v=21#dice"></use></svg></div>
                        <div class="title">Dice</div>
                        <div class="tooltip">Dice</div>
                    </a>
                    <a class="item sidebar__game game_mines" onclick="load('mines')">
                        <div class="icon"><svg class="icon"><use xlink:href="/images/symbols.svg?v=21#mines"></use></svg></div>
                        <div class="title">Mines</div>
                        <div class="tooltip">Mines</div>
                    </a>
                    <a class="item sidebar__game game_coinflip" onclick="load('coinflip')">
                        <div class="icon"><svg class="icon"><use xlink:href="/images/symbols.svg?v=21#coinflip"></use></svg></div>
                        <div class="title">Coinflip</div>
                        <div class="tooltip">Coinflip</div>
                    </a>
                    <a class="item sidebar__game game_x100" onclick="load('x100')">
                        <div class="icon"><svg class="icon"><use xlink:href="/images/symbols.svg?v=21#x100"></use></svg></div>
                        <div class="title">x100</div>
                        <div class="tooltip">x100</div>
                    </a>
                    <a class="item sidebar__game game_x30" onclick="load('x30')">
                        <div class="icon"><svg class="icon"><use xlink:href="/images/symbols.svg?v=21#x30"></use></svg></div>
                        <div class="title">x30</div>
                        <div class="tooltip">x30</div>
                    </a>
                    <a class="item sidebar__game game_keno" onclick="load('keno')">
                        <div class="icon"><svg class="icon"><use xlink:href="/images/symbols.svg?v=21#keno"></use></svg></div>
                        <div class="title">Keno</div>
                        <div class="tooltip">Keno</div>
                    </a>
                    <a class="item sidebar__game game_slots" onclick="load('slots')">
                        <div class="icon"><svg class="icon"><use xlink:href="/images/symbols.svg?v=21#slots"></use></svg></div>
                        <div class="title">Slots</div>
                        <div class="tooltip">Slots</div>
                    </a>
                </div>
                <div class="footer">
                    <a class="gx-btn" rel="popup" data-popup="popup--coupon" onclick="return false;">
                        <svg class="icon"><use xlink:href="/images/symbols.svg?v=24#promo"></use></svg>
                        <div>Промо</div>
                    </a>
                    <a class="gx-btn accent" href="/bonus" onclick="load('bonus');return false;" >
                        <svg class="icon"><use xlink:href="/images/symbols.svg?v=26#gift"></use></svg>
                        <div>Бонусы</div>
                    </a>
                    <a class="gx-btn" href="https://vk.com/public221561395" target="_blank">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" class="icon">
<path d="M17.28 0H6.72C3.00865 0 0 3.00865 0 6.72V17.28C0 20.9914 3.00865 24 6.72 24H17.28C20.9914 24 24 20.9914 24 17.28V6.72C24 3.00865 20.9914 0 17.28 0Z" fill="#0077FF"/>
<path d="M12.5055 15.5188C8.6214 15.5188 6.40677 12.7804 6.31592 8.21639H8.26933C8.3318 11.5633 9.76279 12.9793 10.8985 13.2719V8.21639H12.7327V11.1011C13.8513 10.9782 15.0325 9.66166 15.43 8.21054H17.2584C17.1094 8.96171 16.8115 9.67313 16.3836 10.3003C15.9556 10.9276 15.4068 11.4571 14.7713 11.8559C15.4805 12.2196 16.1068 12.7341 16.6089 13.3655C17.111 13.9969 17.4776 14.7308 17.6843 15.5188H15.6685C15.2369 14.1321 14.158 13.0554 12.7327 12.9091V15.5188H12.5112H12.5055Z" fill="white"/>
</svg>

                        <div>VK</div>
                    </a>
                    <a class="gx-btn" href="https://t.me/goldenxtg" target="_blank">

                        <svg class="icon" width="24" height="24" viewBox="0 0 24 24" fill="none">
<path d="M17.28 0H6.72C3.00865 0 0 3.00865 0 6.72V17.28C0 20.9914 3.00865 24 6.72 24H17.28C20.9914 24 24 20.9914 24 17.28V6.72C24 3.00865 20.9914 0 17.28 0Z" fill="#2FBAFF"/>
<path d="M7.07573 11.5221C10.0426 10.2295 12.021 9.37733 13.0109 8.96559C15.8373 7.79001 16.4246 7.5858 16.8074 7.57898C16.8916 7.57757 17.0798 7.59844 17.2018 7.69738C17.3047 7.78093 17.3331 7.89379 17.3466 7.973C17.3602 8.05221 17.3771 8.23265 17.3636 8.37365C17.2105 9.98293 16.5477 13.8882 16.2106 15.6907C16.0679 16.4533 15.787 16.7091 15.5151 16.7341C14.924 16.7885 14.4752 16.3435 13.9028 15.9683C13.0071 15.3811 12.501 15.0156 11.6316 14.4426C10.6267 13.7804 11.2781 13.4165 11.8508 12.8217C12.0006 12.6661 14.6047 10.2975 14.6551 10.0826C14.6614 10.0558 14.6672 9.95558 14.6077 9.90269C14.5482 9.8498 14.4604 9.86789 14.397 9.88227C14.3072 9.90266 12.8762 10.8485 10.1041 12.7197C9.69796 12.9986 9.33006 13.1345 9.00044 13.1274C8.63705 13.1195 7.93804 12.9219 7.4184 12.753C6.78105 12.5458 6.27449 12.4363 6.3186 12.0844C6.34157 11.9012 6.59395 11.7137 7.07573 11.5221Z" fill="white"/>
</svg>
                        <div>TG</div>
                    </a>
                    <a class="gx-btn">
                        <svg class="icon"><use xlink:href="/images/symbols.svg?v=22#sound"></use></svg>
                    </a>
                </div>
            </div>
            <div class="sidebar__inner d-flex justify-space-between flex-column" style="display: none;">
                <div class="sidebar__top">
                    <div class="sidebar__logotype">
                        <a onclick="load('')" href='#'></a>
                    </div>
                    <div class="sidebar__block sidebar__games  d-flex flex-column justify-center align-center">
                        

                      <a onclick="load('slots')" class="sidebar__game game_slots d-flex justify-center align-center">
                            <div class="sidebar__game-center d-flex align-center justify-center align-center">
                                <svg class="icon"><use xlink:href="/images/symbols.svg?#slots"></use></svg>
                            </div>
                            <div class="sidebar__game-name d-flex align-center flex-end">

                            </div>
                            <div class="sidebar__game--hover"></div>
                        </a>


                        <a href="crash" class="sidebar__game  game_crash d-flex justify-center align-center">
                            <div class="sidebar__game-center d-flex align-center justify-center align-center">
                                <svg class="icon"><use xlink:href="/images/symbols.svg#crash"></use></svg>
                            </div>
                            <div class="sidebar__game-name d-flex align-center flex-end">
                                <span>Crash</span>
                            </div>
                            <div class="sidebar__game--hover"></div>
                        </a>

                        <!--a href="shoot" class="sidebar__game game_shoot d-flex justify-center align-center">
                            <div class="sidebar__game-center d-flex align-center justify-center align-center">
                                <svg class="icon"><use xlink:href="/images/symbols.svg?v=5#hunt"></use></svg>
                            </div>
                            <div class="sidebar__game-name d-flex align-center flex-end">
                                <span>CrazyShoot</span>
                            </div>
                            <div class="sidebar__game--hover"></div>
                        </a---->

                       <a onclick="load('x100')" class="sidebar__game game_x100 d-flex justify-center align-center">
                            <div class="sidebar__game-center d-flex align-center justify-center align-center">
                                <svg class="icon"><use xlink:href="/images/symbols.svg#x100"></use></svg>
                            </div>
                            <div class="sidebar__game-name d-flex align-center flex-end">
                                <span>X100</span>
                            </div>
                            <div class="sidebar__game--hover"></div>
                        </a>

                        <a onclick="load('x30')" class="sidebar__game  game_x30 d-flex justify-center align-center">
                            <div class="sidebar__game-center d-flex align-center justify-center align-center">
                                <svg class="icon"><use xlink:href="/images/symbols.svg#x30"></use></svg>
                            </div>
                            <div class="sidebar__game-name d-flex align-center flex-end">
                                <span>X30</span>
                            </div>
                            <div class="sidebar__game--hover"></div>
                        </a>

                        <a onclick="load('dice')" class="sidebar__game game_dice d-flex justify-center align-center">
                            <div class="sidebar__game-center d-flex align-center justify-center align-center">
                                <svg class="icon"><use xlink:href="/images/symbols.svg#dice"></use></svg>
                            </div>
                            <div class="sidebar__game-name d-flex align-center flex-end">
                                <span>Dice</span>
                            </div>
                            <div class="sidebar__game--hover"></div>
                        </a>

                        <a onclick="load('mines')" class="sidebar__game game_mines d-flex justify-center align-center">
                            <div class="sidebar__game-center d-flex align-center justify-center align-center">
                                <svg class="icon"><use xlink:href="/images/symbols.svg#mines"></use></svg>
                            </div>
                            <div class="sidebar__game-name d-flex align-center flex-end">
                                <span>Mines</span>
                            </div>
                            <div class="sidebar__game--hover"></div>
                        </a>

                        <a onclick="load('coinflip')" class="sidebar__game game_coinflip d-flex justify-center align-center">
                            <div class="sidebar__game-center d-flex align-center justify-center align-center">
                                <svg class="icon"><use xlink:href="/images/symbols.svg?v=3#coinflip"></use></svg>
                            </div>
                            <div class="sidebar__game-name d-flex align-center flex-end">
                                <span>Coin Flip</span>
                            </div>
                            <div class="sidebar__game--hover"></div>
                        </a>

                        <a onclick="load('keno')" class="sidebar__game game_keno d-flex justify-center align-center">
                            <div class="sidebar__game-center d-flex align-center justify-center align-center">
                                <svg class="icon"><use xlink:href="/images/symbols_x.svg?#keno"></use></svg>
                            </div>
                            <div class="sidebar__game-name d-flex align-center flex-end">
                                <span>Keno</span>
                            </div>
                            <div class="sidebar__game--hover"></div>
                        </a>





                    </div>
                                        <div class="sidebar__block sidebar__profile d-flex justify-center align-center flex-column">
                        <div class="sidebar__user-avatar" style="background: url(https://sun9-41.userapi.com/s/v1/ig2/atl0atMOE9mKCHl5G1yfWEffLCDuxQqSPyYsliouwni_Nosnyo_yjpKTFNR9W3T4McnEeQx8dDYJ66lNYJTOE--G.jpg?size=200x200&amp;quality=95&amp;crop=0,245,1170,1170&amp;ava=1) no-repeat center center / cover;"></div>

                    </div>
                                    </div>
                <div class="sidebar__socials d-flex flex-column align-center justify-center">
                    <a href="https://vk.com/public221561395" target="_blank" class="sidebar__social--vk d-flex align-center justify-center">
                        <svg class="icon"><use xlink:href="/images/symbols.svg?v=2#vk"></use></svg>
                    </a>
                    <a href="https://t.me/goldenxtg" target="_blank" class="sidebar__social--tg d-flex align-center justify-center">
                        <svg class="icon"><use xlink:href="/images/symbols.svg?v=2#telegram"></use></svg>
                    </a>
                </div>

            </div>
        </div>
	
 
<div class="main">		
<div class="header">
                <div class="wrapper d-flex align-center justify-space-between">
                    <nav class="header__links d-flex align-center">
                        <li>
                            <a href="#" onclick="load('')" class="d-flex align-center">
                                <svg class="icon"><use xlink:href="images/symbols.svg#game_menu"></use></svg>
                                <span>Игры</span>
                            </a>
                        </li>
                        <li>
                            <a href="#" onclick="load('bonus')" class="d-flex align-center">
                                <svg class="icon"><use xlink:href="images/symbols.svg#gift"></use></svg>
                                <span>Бонусы</span>
                            </a>
                        </li>
                        <li>
                            <a href="#" onclick="load('refs')" class="d-flex align-center" style="gap: 10px;">
                            <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.1667 10.4167C16.0784 10.4167 19.5833 11.1309 19.5833 13.9881C19.5833 15.2381 19.2647 15.4167 18.6275 15.4167L13.5523 15.4173C13.684 15.0097 13.75 14.5317 13.75 13.9881C13.75 12.5524 13.2239 11.4324 12.3568 10.6032C13.0094 10.4695 13.6469 10.4167 14.1667 10.4167ZM6.66667 10.4167C8.57843 10.4167 12.0833 11.1309 12.0833 13.9881C12.0833 15.2381 11.7647 15.4167 11.1275 15.4167H2.20588C1.56863 15.4167 1.25 15.2381 1.25 13.9881C1.25 11.1309 4.7549 10.4167 6.66667 10.4167ZM6.66667 4.16666C8.04792 4.16666 9.16667 5.28541 9.16667 6.66666C9.16667 8.04791 8.04792 9.16666 6.66667 9.16666C5.28542 9.16666 4.16667 8.04791 4.16667 6.66666C4.16667 5.28541 5.28542 4.16666 6.66667 4.16666ZM14.1667 4.16666C15.5479 4.16666 16.6667 5.28541 16.6667 6.66666C16.6667 8.04791 15.5479 9.16666 14.1667 9.16666C12.7854 9.16666 11.6667 8.04791 11.6667 6.66666C11.6667 5.28541 12.7854 4.16666 14.1667 4.16666Z" fill="#7785B3"/>
</svg>
                                <span>Рефералы</span>
                            </a>
                        </li>
                        <li>
                            <a href="#" onclick="load('faq')" class="d-flex align-center">
                                <svg class="icon"><use xlink:href="images/symbols.svg?v=28#faq"></use></svg>
                                <span>Помощь</span>
                            </a>
                        </li>

                        <li>
                            <a onclick="load('support')" target="_blank" class="d-flex align-center">
                                <svg class="icon"><use xlink:href="images/symbols.svg?v=29#support"></use></svg>
                                <span>Поддержка</span>
                            </a>
                        </li>
                                                                    </nav>
                    <div class="header__right d-flex align-center">
                        <div class="sidebar__logotype flare">
                            <a href="#" onclick="load('')"></a>
                        </div>
@auth
                    @php
                    $min_sort = \App\SystemDep::min('sort');
                    @endphp
                            <div class="header__user d-flex align-center justify-space-between">
                            <div class="header__user-balance d-flex align-center">
                                <div class="header__user-b d-flex align-center" style="gap: 5px;">
                                <svg class="icon"><use xlink:href="images/symbols.svg#coins"></use></svg>
                                    <span id="balance" onclick="$('.wallet__method--sort-1_DEPOSIT').click();$('.wallet__method--Qiwi_WITHDRAW').click()" style="cursor:pointer;" rel="popup" data-popup="popup--wallet"></span>

                                </div>
                                <div class="header__user-balance-add">
                                    <a href="#" onclick="$('.wallet__method--sort-1_DEPOSIT').click();$('.wallet__method--Qiwi_WITHDRAW').click()" rel="popup" data-popup="popup--wallet" onclick="return false;" style="gap: 5px;" class="btn is-ripples flare d-flex align-center"><svg xmlns="http://www.w3.org/2000/svg"  width="18" height="18" viewBox="0 0 21 18" fill="none">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M5.85428 3.76001e-05C5.90212 5.70907e-05 5.95068 7.68496e-05 5.99998 7.68496e-05H12C12.0492 7.68496e-05 12.0978 5.70907e-05 12.1456 3.76001e-05C13.0498 -0.000330934 13.6991 -0.000595582 14.263 0.134773C16.0455 0.562721 17.4373 1.95448 17.8652 3.73701C17.9471 4.07797 17.9789 4.44474 17.9914 4.87153C19.1855 5.36642 20.1342 6.31527 20.6288 7.50946C20.8378 8.01396 20.922 8.54138 20.9616 9.12162C20.9999 9.68307 20.9999 10.3705 20.9999 11.2109V11.2891C20.9999 12.1296 20.9999 12.817 20.9616 13.3784C20.922 13.9587 20.8378 14.4861 20.6288 14.9906C20.134 16.1851 19.185 17.1341 17.9905 17.6289C17.486 17.8379 16.9586 17.9221 16.3783 17.9617C15.8169 18 15.1295 18 14.2891 18H7.07782C6.06777 18 5.24172 18 4.57038 17.9452C3.87549 17.8884 3.24789 17.7673 2.66178 17.4687C1.7445 17.0013 0.998722 16.2555 0.531342 15.3382C0.232704 14.7521 0.111603 14.1245 0.0548288 13.4296C-2.21281e-05 12.7583 -1.27386e-05 11.9322 4.04175e-07 10.9222L0.000217841 5.623C0.00162269 4.85395 0.00749679 4.26684 0.134697 3.73701C0.562645 1.95448 1.95441 0.562721 3.73694 0.134773C4.30079 -0.000595582 4.95011 -0.000330934 5.85428 3.76001e-05ZM15.7178 4.50988C15.7075 4.41082 15.6943 4.33279 15.6774 4.26226C15.447 3.30244 14.6976 2.55303 13.7377 2.3226C13.4683 2.2579 13.1108 2.25007 12 2.25007H5.99998C4.88911 2.25007 4.53166 2.2579 4.26219 2.3226C3.30236 2.55303 2.55295 3.30244 2.32252 4.26226C2.30629 4.32988 2.2934 4.405 2.28327 4.50006H14.2499C14.285 4.50006 14.3197 4.50005 14.3543 4.50005C14.8573 4.5 15.3095 4.49996 15.7178 4.50988ZM2.24999 6.75005V10.875C2.24999 11.9437 2.25087 12.6775 2.29735 13.2464C2.34275 13.8021 2.42601 14.1007 2.5361 14.3167C2.78776 14.8107 3.18934 15.2122 3.68326 15.4639C3.89932 15.574 4.19785 15.6572 4.7536 15.7027C5.32248 15.7491 6.05631 15.75 7.12497 15.75H14.2499C15.139 15.75 15.7494 15.7494 16.2252 15.7169C16.6909 15.6852 16.9448 15.6267 17.1295 15.5502C17.7727 15.2838 18.2837 14.7728 18.5501 14.1296C18.6266 13.9449 18.6851 13.691 18.7169 13.2253C18.7493 12.7495 18.7499 12.1391 18.7499 11.25C18.7499 10.361 18.7493 9.75057 18.7169 9.27478C18.6851 8.8091 18.6266 8.55514 18.5501 8.3705C18.2837 7.7273 17.7727 7.21628 17.1295 6.94986C17.0193 6.90421 16.8835 6.86481 16.6937 6.83385C16.2023 6.7537 15.5182 6.75005 14.2499 6.75005H2.24999ZM12 10.5C12 9.87871 12.5036 9.37504 13.1249 9.37504H15.3749C15.9963 9.37504 16.4999 9.87871 16.4999 10.5C16.4999 11.1213 15.9963 11.625 15.3749 11.625H13.1249C12.5036 11.625 12 11.1213 12 10.5Z" fill="white"/>
                                    </svg> <span> Кошелёк</span></a>
                                </div>
                            </div>
                            <div class="header__user-profile d-flex align-center" id="dropdownUser">


                                <div class="user-split">
                                    <div class="user-avatar" style="background: url({{\Auth::user()->avatar}}) no-repeat center center / cover;"></div>
                                    <span>{{\Auth::user()->name}}</span>
                                </div>

                                <div class="header__user-dropdown d-flex flex-column">
                                    <a href="#" class="header__user-dropdown--id d-flex align-center">
                                        <span>ID: <b>{{\Auth::user()->id}}</b></span>
                                    </a>
                                    <a href="#" onclick="load('profile')" class="d-flex align-center">
                                        <svg class="icon"><use xlink:href="images/symbols.svg#user"></use></svg>
                                        <span>Профиль</span>
                                    </a>
                                    <a href="#" rel="popup" data-popup="popup--coupon" onclick="return false;" class="d-flex align-center">
                                        <svg class="icon"><use xlink:href="images/symbols.svg#coupon"></use></svg>
                                        <span>Промокоды</span>
                                    </a>

                                    <!-- <a href="#" id="darkTheme" onclick="return false;" class="d-flex align-center">
                                        <svg class="icon"><use xlink:href="images/symbols.svg?v=1#dark"></use></svg>
                                        <span>Темная тема</span>
                                        <em>new</em>
                                    </a>
                                    <a href="#" id="lightTheme" onclick="return false;" class="d-flex align-center">
                                        <svg class="icon"><use xlink:href="images/symbols.svg?v=1#light"></use></svg>
                                        <span>Светлая тема</span>
                                    </a> -->

                                    <a href="logout" onclick="location.href='logout'" class="d-flex align-center">
                                        <svg class="icon"><use xlink:href="images/symbols.svg#exit"></use></svg>
                                        <span>Выйти</span>
                                    </a>
                                </div>
                            </div>
							@else
							<a href="#" rel="popup" data-popup="popup--auth" onclick="return false;" class="btn is-ripples btn--blue d-flex align-center flare has-ripple"><span>Авторизация <svg width="14" height="15" viewBox="0 0 14 15" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7 0C9.41625 0 11.375 1.86548 11.375 4.16667L11.3741 5.83333H11.7566C12.5367 5.83333 12.8196 5.91069 13.1047 6.05594C13.3899 6.2012 13.6137 6.41436 13.7663 6.68596C13.9188 6.95757 14 7.22697 14 7.9699V12.8634C14 13.6064 13.9188 13.8758 13.7663 14.1474C13.6137 14.419 13.3899 14.6321 13.1047 14.7774C12.8196 14.9226 12.5367 15 11.7566 15H2.2434C1.46332 15 1.18045 14.9226 0.89526 14.7774C0.610075 14.6321 0.38626 14.419 0.233741 14.1474C0.0812225 13.8758 0 13.6064 0 12.8634V7.9699C0 7.22697 0.0812225 6.95757 0.233741 6.68596C0.38626 6.41436 0.610075 6.2012 0.89526 6.05594C1.18045 5.91069 1.46332 5.83333 2.2434 5.83333H2.62413L2.625 4.16667C2.625 1.86548 4.58375 0 7 0ZM7 1.66667C5.55025 1.66667 4.375 2.78595 4.375 4.16667L4.37412 5.83333H9.62412L9.625 4.16667C9.625 2.78595 8.44975 1.66667 7 1.66667Z" fill="white"></path>
</svg>
</span><span class="ripple ripple-animate" style="height: 143.806px; width: 143.806px; animation-duration: 0.3s; animation-timing-function: linear; background: rgb(255, 255, 255); opacity: 0.4; top: -59.4586px; left: -29.9308px;"></span></a>	
				
	@endauth
                            
                        </div>
                                            </div>
           </div>	    
@auth
           </div>	    
@endauth
			
        <div class="gx-s"><script src="js/script.js?v={{time()}}" type="text/javascript"></script>
		<main id="_ajax_content_">
		
		{!! html_entity_decode($page) !!}
		</main>
        <footer class="footer">
                    <div class="wrapper gx-container gx-wrap">
                        <div class="gx-row flex-wrap justify-space-between align-center gx-gap gx-mh-0">
                            <div class="gx-col">
                                <div class="gx-row align-center">
                                    <div class="logo" style="padding-left: 0;">
                                        <a class="logoim" onclick="load('')" href='#'></a>
                                    </div>
                                    <span class="text-gray">{{$setting->name}} – Экономическая онлайн стратегия</span>
                                </div>
                            </div>
                            <div class="gx-col justify-center">
                                <div class="gx-row align-center gx-gap">
                                    <span class="text-gray">Социальные сети:</span>
                                    <div class="gx-row gx-gap">
                                        <a class="gx-btn soc" href="https://vk.com/{{\App\Setting::first()->group_id}}" target="_blank">
                                        <svg class="ft-soc" fill="none">
<path d="M17.28 0H6.72C3.00865 0 0 3.00865 0 6.72V17.28C0 20.9914 3.00865 24 6.72 24H17.28C20.9914 24 24 20.9914 24 17.28V6.72C24 3.00865 20.9914 0 17.28 0Z" fill="#0077FF"></path>
<path d="M12.5055 15.5188C8.6214 15.5188 6.40677 12.7804 6.31592 8.21639H8.26933C8.3318 11.5633 9.76279 12.9793 10.8985 13.2719V8.21639H12.7327V11.1011C13.8513 10.9782 15.0325 9.66166 15.43 8.21054H17.2584C17.1094 8.96171 16.8115 9.67313 16.3836 10.3003C15.9556 10.9276 15.4068 11.4571 14.7713 11.8559C15.4805 12.2196 16.1068 12.7341 16.6089 13.3655C17.111 13.9969 17.4776 14.7308 17.6843 15.5188H15.6685C15.2369 14.1321 14.158 13.0554 12.7327 12.9091V15.5188H12.5112H12.5055Z" fill="white"></path>
</svg>
                                        </a>
                                        <a class="gx-btn soc" href="https://t.me/{{\App\Setting::first()->tg_id}}" target="_blank">
                                        <svg class="ft-soc" fill="none">
<path d="M17.28 0H6.72C3.00865 0 0 3.00865 0 6.72V17.28C0 20.9914 3.00865 24 6.72 24H17.28C20.9914 24 24 20.9914 24 17.28V6.72C24 3.00865 20.9914 0 17.28 0Z" fill="#2FBAFF"></path>
<path d="M7.07573 11.5221C10.0426 10.2295 12.021 9.37733 13.0109 8.96559C15.8373 7.79001 16.4246 7.5858 16.8074 7.57898C16.8916 7.57757 17.0798 7.59844 17.2018 7.69738C17.3047 7.78093 17.3331 7.89379 17.3466 7.973C17.3602 8.05221 17.3771 8.23265 17.3636 8.37365C17.2105 9.98293 16.5477 13.8882 16.2106 15.6907C16.0679 16.4533 15.787 16.7091 15.5151 16.7341C14.924 16.7885 14.4752 16.3435 13.9028 15.9683C13.0071 15.3811 12.501 15.0156 11.6316 14.4426C10.6267 13.7804 11.2781 13.4165 11.8508 12.8217C12.0006 12.6661 14.6047 10.2975 14.6551 10.0826C14.6614 10.0558 14.6672 9.95558 14.6077 9.90269C14.5482 9.8498 14.4604 9.86789 14.397 9.88227C14.3072 9.90266 12.8762 10.8485 10.1041 12.7197C9.69796 12.9986 9.33006 13.1345 9.00044 13.1274C8.63705 13.1195 7.93804 12.9219 7.4184 12.753C6.78105 12.5458 6.27449 12.4363 6.3186 12.0844C6.34157 11.9012 6.59395 11.7137 7.07573 11.5221Z" fill="white"></path>
</svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="gx-row flex-wrap justify-space-between align-center gx-gap gx-mh-0">
                            <div class="gx-col">
                                <nav class="footer__links d-flex">
                                    <li class="footer__link">
                                        <a href="#" onclick="load('terms')">Термины</a>
                                    </li>
                                    <li class="footer__link">
                                        <a href="#" onclick="load('policy')">Пользовательское соглашение</a>
                                    </li>
                                    <li class="footer__link">
                                        <a href="#" onclick="load('support')">Поддержка</a>
                                    </li>
                                    <li class="footer__link">
                                        <a href="#" onclick="load('contacts')">Контакты</a>
                                    </li>
                                </nav>
                            </div>
                            <div class="gx-col">
                                <div class="gx-con red">
                                    <div class="icon"><span>18+</span></div>
                                    <div class="title">Играйте ответственно </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </footer>
				
				<div class="mobile-menu d-flex align-center">
                <nav class="mobile-menu__links d-flex align-center justify-space-between">
                    <li style="margin-top: 7px;"><a class="btn_active btn_bonus" onclick="load('bonus')"><svg class="icon_mobiles"><use xlink:href="images/symbols.svg#gift"></use></svg>
               
                </a>
                <span class="mobile_p">Бонусы</span>
            </li>
                    <li style="margin-top: 7px;"><a href="#" class="chatBtn"><svg class="icon_mobiles"><use xlink:href="images/symbols.svg#support"></use></svg>
                   
                </a>
                <span class="mobile_p">Чат</span>
                </li>
                    <li><a class="btn_active btn_ active" onclick="load('')"><svg class="icon_mobiles"><use xlink:href="images/symbols.svg#game_menu"></use></svg>
                  
                </a>
                <span class="mobile_p">Игры</span>
            </li>
                    <li><a rel="popup" data-popup="popup--wallet">
                    <svg class="icon_mobiles" width="24" height="24" viewBox="0 0 24 24">
<path d="M22.5 18V19.875C22.5 20.9092 21.6585 21.75 20.625 21.75H4.5C2.8455 21.75 1.5 20.4045 1.5 18.75C1.5 18.75 1.5 6.01125 1.5 6C1.5 4.3455 2.8455 3 4.5 3H18.375C18.9967 3 19.5 3.504 19.5 4.125C19.5 4.746 18.9967 5.25 18.375 5.25H4.5C4.08675 5.25 3.75 5.586 3.75 6C3.75 6.414 4.08675 6.75 4.5 6.75H20.625C21.6585 6.75 22.5 7.59075 22.5 8.625V10.5H18.75C16.6823 10.5 15 12.1823 15 14.25C15 16.3177 16.6823 18 18.75 18H22.5Z"></path>
<path d="M22.5 12V16.5H18.75C17.5073 16.5 16.5 15.4927 16.5 14.25C16.5 13.0073 17.5073 12 18.75 12H22.5Z"></path>
</svg>
                    </a>
                    <span class="mobile_p">Кошелек</span>
                </li>
                    <li><a href="#" id="moreBtn">
                    <svg class="icon_mobiles" width="512" height="512" fill="currentColor" viewBox="0 0 512 512"><g><path d="M31.125 126.493h449.757c17.162 0 31.118-13.956 31.118-31.118S498.044 64.25 480.882 64.25H31.125C13.963 64.25 0 78.213 0 95.375s13.963 31.118 31.125 31.118zM480.882 224.875H31.125C13.963 224.875 0 238.838 0 256s13.963 31.118 31.125 31.118h449.757C498.044 287.118 512 273.162 512 256s-13.956-31.125-31.118-31.125zM480.882 385.5H31.125C13.963 385.5 0 399.471 0 416.632c0 17.162 13.963 31.118 31.125 31.118h449.757c17.162 0 31.118-13.956 31.118-31.118 0-17.161-13.956-31.132-31.118-31.132z"></path></g></svg>
                    
                </a>
                <span class="mobile_p">Меню</span>
            </li>
                </nav>
</div>
			<div class="mobile-navbar d-flex flex-column">
                <li class="d-flex flex-column">
                    <a onclick="$('#moreBtn').click();load('')" href="#"><svg class="icon mobilesli"><use xlink:href="images/symbols.svg#game_menu"></use></svg> Игры</a>
                    <a onclick="$('#moreBtn').click();load('bonus')"><svg class="icon mobilesli"><use xlink:href="images/symbols.svg#gift"></use></svg> Бонусы</a>
                    <a onclick="$('#moreBtn').click();load('refs')"><svg class="icon mobilesli"><use xlink:href="images/symbols.svg#users"></use></svg>Рефералы</a>
                    <a onclick="$('#moreBtn').click();load('faq')"><svg class="icon mobilesli"><use xlink:href="images/symbols.svg#faq"></use></svg> Faq</a>
                    <a onclick="$('#moreBtn').click();load('support')"><svg class="icon mobilesli"><use xlink:href="images/symbols.svg#support"></use></svg> Поддержка</a>
                                                            

                </li>
            </div>
			</div>
				
            </div>

    </div>
</div>

    <div class="overlayed">
        @guest
        <div class="popup popup--auth">
       
            <div class="gx-split">
                <div class="gx-col gx-left gx-comp-1">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 271 318" fill="none" class="gx-floating gx-wh-1">
                        <path style="mix-blend-mode:overlay" opacity="0.15" fill-rule="evenodd" clip-rule="evenodd" d="M140.189 159.223C140.192 159.132 140.189 159.038 140.192 158.951L343 155.664C342.01 136.065 342.852 145.857 340.451 126.302L140.132 158.23C140.119 158.146 140.095 158.052 140.082 157.959C140.059 157.868 140.038 157.781 140.014 157.693L335.651 104.031C329.746 85.1374 333.031 94.4527 325.807 76.0834L139.775 157.018C139.735 156.927 139.694 156.846 139.662 156.766C139.618 156.685 139.574 156.602 139.527 156.524L315.602 55.7406C305.241 39.0315 310.713 47.1864 299.201 31.2693L139.133 155.927C139.068 155.859 139.011 155.783 138.948 155.711C138.891 155.645 138.826 155.573 138.763 155.51L284.346 14.1772C270.202 0.580719 277.503 7.12253 262.425 -5.45475L138.226 155.03C138.151 154.976 138.082 154.926 138.007 154.866C137.929 154.816 137.85 154.765 137.775 154.715L243.76 -18.3664C226.574 -28.0906 235.323 -23.5482 217.521 -32.005L137.144 154.387C137.053 154.35 136.969 154.317 136.886 154.286C136.798 154.252 136.714 154.218 136.623 154.196L196.092 -39.897C177.035 -45.0075 186.631 -42.8036 167.28 -46.533L135.922 154.038C135.835 154.025 135.747 154.007 135.647 153.998C135.562 153.991 135.465 153.988 135.377 153.977L144.741 -48.8147C125.069 -49.0403 134.897 -49.274 115.342 -48.1185L134.654 153.998C134.563 154.007 134.472 154.014 134.375 154.028C134.284 154.045 134.204 154.059 134.109 154.079L92.7739 -44.7251C73.595 -40.0285 83.1001 -42.7192 64.2749 -36.6578L133.418 154.274C133.333 154.304 133.242 154.337 133.161 154.379C133.075 154.408 132.988 154.452 132.907 154.489L43.3099 -27.7385C25.982 -18.4313 34.4699 -23.3875 17.8478 -12.881L132.287 154.846C132.214 154.906 132.139 154.957 132.065 155.009C131.993 155.065 131.92 155.126 131.849 155.182L-0.145233 0.892307C-14.5919 14.1609 -7.60946 7.27995 -21.0811 21.5353L131.343 155.694C131.286 155.76 131.224 155.828 131.161 155.904C131.111 155.973 131.051 156.049 130.994 156.125L-35.1367 39.3609C-45.8845 55.8591 -40.8067 47.4218 -50.3799 64.6843L130.63 156.744C130.59 156.817 130.546 156.907 130.509 156.989C130.471 157.073 130.436 157.161 130.402 157.247L-59.5816 85.5334C-65.8892 104.255 -63.0745 94.8 -68.0322 113.927L130.197 157.933C130.181 158.027 130.163 158.118 130.147 158.204C130.134 158.295 130.119 158.383 130.11 158.477L-71.7165 136.302C-73.1652 155.927 -68.5871 145.96 -68.652 165.645L130.084 159.199C130.087 159.29 130.093 159.384 130.1 159.472C130.11 159.566 130.121 159.66 130.131 159.751L-70.9021 188.364C-67.4287 207.822 -69.5085 198.179 -64.6578 217.322L130.282 160.452C130.309 160.536 130.338 160.627 130.369 160.716C130.4 160.797 130.436 160.882 130.47 160.969L-57.0865 238.829C-48.8582 256.781 -53.2806 247.964 -43.8323 265.241L130.783 161.611C130.836 161.688 130.89 161.773 130.934 161.846C130.991 161.919 131.044 161.997 131.099 162.071L-31.1897 284.097C-18.8537 299.341 -25.2845 291.948 -11.9037 306.29L131.565 162.617C131.628 162.677 131.7 162.742 131.766 162.802C131.834 162.862 131.904 162.923 131.974 162.983L4.97639 321.409C20.7355 333.158 12.6677 327.577 29.2201 338.184L132.566 163.388C132.644 163.435 132.728 163.475 132.811 163.526C132.892 163.566 132.975 163.602 133.059 163.642L49.4357 348.687C67.7434 356.18 58.4703 352.763 77.229 358.923L133.731 163.892C133.825 163.923 133.903 163.943 133.993 163.962C134.091 163.983 134.182 163.999 134.273 164.016L99.4724 364.043C118.869 366.7 109.119 365.71 128.731 367L134.991 164.09C135.079 164.094 135.176 164.09 135.259 164.094C135.359 164.09 135.447 164.084 135.538 164.079L151.378 366.461C170.966 364.227 161.219 365.692 180.615 362.06L136.247 163.972C136.341 163.949 136.425 163.928 136.516 163.9C136.602 163.873 136.688 163.847 136.777 163.819L202.585 355.836C220.988 348.78 211.913 352.638 229.797 344.268L137.438 163.534C137.516 163.493 137.6 163.449 137.679 163.402C137.756 163.355 137.833 163.308 137.911 163.264L249.401 332.824C265.399 321.454 257.616 327.413 272.764 314.948L138.481 162.816C138.551 162.763 138.619 162.696 138.679 162.635C138.748 162.562 138.813 162.5 138.883 162.433L288.888 299.044C301.587 284.055 295.509 291.767 307.123 275.903L139.316 161.867C139.37 161.791 139.42 161.71 139.47 161.638C139.511 161.557 139.558 161.474 139.605 161.396L318.862 256.401C327.478 238.637 323.487 247.672 330.826 229.289L139.895 160.737C139.925 160.65 139.952 160.562 139.985 160.471C140.003 160.387 140.032 160.296 140.053 160.208L337.325 207.463C341.222 188.148 339.626 197.84 342.126 178.383L140.17 159.504C140.173 159.41 140.183 159.319 140.186 159.218L140.189 159.223Z" fill="url(#paint0_radial_223_20547)"></path>
                        <defs>
                            <radialGradient id="paint0_radial_223_20547" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(133.835 151.503) scale(201.638 201.709)">
                            <stop stop-color="white"></stop>
                            <stop offset="0.15" stop-color="white" stop-opacity="0.99"></stop>
                            <stop offset="0.28" stop-color="white" stop-opacity="0.94"></stop>
                            <stop offset="0.4" stop-color="white" stop-opacity="0.87"></stop>
                            <stop offset="0.51" stop-color="white" stop-opacity="0.78"></stop>
                            <stop offset="0.63" stop-color="white" stop-opacity="0.65"></stop>
                            <stop offset="0.74" stop-color="white" stop-opacity="0.49"></stop>
                            <stop offset="0.85" stop-color="white" stop-opacity="0.3"></stop>
                            <stop offset="0.96" stop-color="white" stop-opacity="0.1"></stop>
                            <stop offset="1" stop-color="white" stop-opacity="0"></stop>
                            </radialGradient>
                        </defs>
                    </svg>
                    <div class="gx-floating-logo"></div>
                    <div class="gx-comp-el-0"></div>
                    <div class="gx-comp-el-1">
                    <svg xmlns="http://www.w3.org/2000/svg" width="67" height="198" viewBox="0 0 67 198" fill="none">
  <g style="mix-blend-mode:luminosity" filter="url(#filter0_f_223_20549)">
    <path d="M22.1197 29.1767L23.5347 34.4271C24.2377 36.9015 26.393 38.8615 29.9416 39.8123C37.8726 41.9374 49.7366 38.2254 56.4407 31.5213C60.2353 27.7267 61.5613 23.7875 60.5612 20.6971L59.2141 15.6478L22.1197 29.1767Z" fill="url(#paint0_linear_223_20549)"></path>
    <path d="M38.9541 32.1432L31.9694 32.76L34.0152 40.3951C36.2305 40.4766 38.5969 40.2294 40.9777 39.6955L38.9541 32.1432Z" fill="url(#paint1_linear_223_20549)"></path>
    <path d="M58.1069 29.6477C60.6059 26.4579 61.397 23.2808 60.5608 20.6972L59.2137 15.6478L56.4351 23.4084L58.1069 29.6477Z" fill="url(#paint2_linear_223_20549)"></path>
    <path d="M26.3011 18.546C19.5971 25.25 20.5917 32.4075 28.5227 34.5326C36.4537 36.6576 48.3176 32.9457 55.0217 26.2417C61.7257 19.5376 60.7311 12.3801 52.8001 10.2551C44.8691 8.13002 33.0052 11.8419 26.3011 18.546Z" fill="url(#paint3_linear_223_20549)"></path>
    <path d="M28.5226 34.5328C36.4536 36.6579 48.3176 32.9459 55.0217 26.2419C56.6938 24.5697 57.8869 22.8693 58.6129 21.2259L23.3437 22.3175C20.2114 27.7502 22.0741 32.8048 28.5226 34.5328Z" fill="url(#paint4_linear_223_20549)"></path>
    <path d="M39.8604 16.6289C39.4399 16.7605 39.0281 16.9065 38.6265 17.0653C37.6515 17.4509 37.2877 18.0485 37.6931 18.5707L38.2243 19.2549C38.5053 19.6169 39.5058 19.7349 40.2442 19.5024C40.2492 19.5009 40.2541 19.4993 40.2591 19.4977C42.9105 18.6682 45.2401 19.2924 45.4624 20.892C45.6847 22.4916 43.7155 24.4609 41.064 25.2904C38.4125 26.12 36.083 25.4957 35.8607 23.8961C35.8604 23.8939 35.8601 23.8916 35.8598 23.8894C35.8146 23.5544 35.0677 23.3427 34.3388 23.4663L32.719 23.741C31.7559 23.9043 31.0914 24.3104 31.0749 24.7555C31.067 24.9676 31.0768 25.1774 31.1055 25.384C31.548 28.568 36.1851 29.8105 41.4628 28.1592C46.7405 26.5079 50.6602 22.5882 50.2178 19.4043C49.7752 16.2202 45.1381 14.9776 39.8604 16.6289Z" fill="url(#paint5_linear_223_20549)"></path>
    <path d="M39.2591 12.301C30.0195 15.1919 23.1573 22.0541 23.9319 27.6282C24.7065 33.2023 32.8246 35.3776 42.0642 32.4867C51.3037 29.5959 58.166 22.7336 57.3914 17.1595C56.6168 11.5855 48.4987 9.4102 39.2591 12.301ZM54.8534 17.9537C55.5104 22.6822 49.6893 28.5033 41.8514 30.9556C34.0136 33.4078 27.1271 31.5626 26.4701 26.8341C25.813 22.1057 31.6342 16.2845 39.472 13.8322C47.3097 11.38 54.1962 13.2252 54.8534 17.9537Z" fill="url(#paint6_linear_223_20549)"></path>
    <path d="M54.8064 17.677C54.8242 17.7682 54.8405 17.8601 54.8534 17.9536C55.5105 22.6821 49.6893 28.5032 41.8515 30.9555C34.5683 33.2343 28.1075 31.8016 26.7023 27.7934C27.5857 32.3162 34.3537 34.0421 42.0367 31.6384C49.8745 29.1861 55.6956 23.3649 55.0386 18.6364C54.9921 18.3018 54.9134 17.9822 54.8064 17.677Z" fill="url(#paint7_linear_223_20549)"></path>
    <path d="M23.9319 27.6284C23.9839 28.0025 24.07 28.3607 24.1862 28.7038C24.1595 28.5747 24.1355 28.4442 24.117 28.3112C23.3424 22.7371 30.2046 15.8748 39.4442 12.984C48.0638 10.2872 55.7061 11.9998 57.3222 16.7672C56.2275 11.4853 48.2782 9.47931 39.2591 12.3012C30.0196 15.192 23.1574 22.0542 23.9319 27.6284Z" fill="url(#paint8_linear_223_20549)"></path>
  </g>
  <g style="mix-blend-mode:luminosity">
    <path d="M38.5553 148.14L36.1542 139.23C34.9613 135.032 31.3039 131.706 25.2823 130.092C11.8241 126.486 -8.30794 132.785 -19.6841 144.161C-26.1231 150.6 -28.3733 157.285 -26.6761 162.529L-24.3902 171.097L38.5553 148.14Z" fill="url(#paint9_linear_223_20549)"></path>
    <path d="M9.98795 143.106L21.8402 142.059L18.3687 129.103C14.6096 128.965 10.594 129.385 6.55413 130.291L9.98795 143.106Z" fill="url(#paint10_linear_223_20549)"></path>
    <path d="M31.4581 166.179C42.8343 154.803 41.1465 142.657 27.6883 139.051C14.2301 135.445 -5.90176 141.744 -17.2779 153.12C-28.654 164.496 -26.9662 176.642 -13.5081 180.248C-0.0498806 183.854 20.082 177.555 31.4581 166.179Z" fill="url(#paint11_linear_223_20549)"></path>
    <path d="M27.6896 139.051C14.2315 135.445 -5.90067 141.744 -17.2768 153.12C-20.1142 155.957 -22.1387 158.843 -23.3707 161.632L36.4776 159.779C41.7929 150.56 38.632 141.983 27.6896 139.051Z" fill="url(#paint12_linear_223_20549)"></path>
    <path d="M8.44997 169.432C9.1634 169.209 9.86224 168.961 10.5438 168.692C12.1982 168.037 12.8156 167.023 12.1277 166.137L11.2263 164.976C10.7494 164.362 9.05162 164.162 7.79864 164.556C7.79017 164.559 7.78189 164.561 7.77342 164.564C3.27416 165.972 -0.678879 164.913 -1.05611 162.198C-1.43333 159.484 1.90827 156.142 6.40754 154.735C10.9068 153.327 14.8598 154.386 15.2371 157.1C15.2375 157.104 15.2381 157.108 15.2386 157.112C15.3153 157.68 16.5827 158.04 17.8195 157.83L20.5682 157.364C22.2024 157.087 23.3301 156.397 23.3581 155.642C23.3714 155.282 23.3549 154.926 23.3061 154.576C22.5553 149.173 14.6866 147.064 5.7308 149.866C-3.22491 152.668 -9.87633 159.32 -9.12554 164.723C-8.37456 170.126 -0.505744 172.234 8.44997 169.432Z" fill="url(#paint13_linear_223_20549)"></path>
    <path d="M9.47068 176.776C25.1493 171.871 36.7938 160.226 35.4794 150.767C34.165 141.309 20.3894 137.617 4.71078 142.523C-10.9679 147.428 -22.6124 159.073 -21.298 168.532C-19.9836 177.99 -6.20795 181.682 9.47068 176.776ZM-16.9913 167.184C-18.1062 159.16 -8.22828 149.282 5.07173 145.121C18.3718 140.96 30.0575 144.091 31.1725 152.115C32.2874 160.139 22.4095 170.017 9.10945 174.178C-4.19045 178.339 -15.8762 175.208 -16.9913 167.184Z" fill="url(#paint14_linear_223_20549)"></path>
    <path d="M-16.9111 167.653C-16.9413 167.498 -16.969 167.343 -16.991 167.184C-18.1059 159.16 -8.22797 149.282 5.07203 145.121C17.431 141.254 28.3942 143.685 30.7787 150.487C29.2797 142.812 17.795 139.883 4.75785 143.962C-8.54216 148.123 -18.4201 158.001 -17.3052 166.025C-17.2263 166.593 -17.0927 167.135 -16.9111 167.653Z" fill="url(#paint15_linear_223_20549)"></path>
    <path d="M35.4794 150.767C35.3912 150.132 35.245 149.524 35.0478 148.942C35.0932 149.161 35.1339 149.383 35.1653 149.608C36.4797 159.067 24.8352 170.712 9.15652 175.617C-5.47004 180.193 -18.4384 177.287 -21.1807 169.197C-19.3231 178.16 -5.83391 181.564 9.4706 176.776C25.1492 171.87 36.7937 160.226 35.4794 150.767Z" fill="url(#paint16_linear_223_20549)"></path>
  </g>
  <defs>
    <filter id="filter0_f_223_20549" x="17.8576" y="5.65641" width="47.0247" height="38.7546" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"></feBlend>
      <feGaussianBlur stdDeviation="2" result="effect1_foregroundBlur_223_20549"></feGaussianBlur>
    </filter>
    <linearGradient id="paint0_linear_223_20549" x1="51.3106" y1="27.3607" x2="20.8994" y2="35.5093" gradientUnits="userSpaceOnUse">
      <stop stop-color="#BA5C25"></stop>
      <stop offset="0.2216" stop-color="#FFC538"></stop>
      <stop offset="0.3753" stop-color="#FFA538"></stop>
      <stop offset="0.5003" stop-color="#FBC23C"></stop>
      <stop offset="0.6256" stop-color="#F8D840"></stop>
      <stop offset="0.7058" stop-color="#F7E041"></stop>
      <stop offset="0.7857" stop-color="#F9D53F"></stop>
      <stop offset="0.9265" stop-color="#FDB73B"></stop>
      <stop offset="1" stop-color="#FFA538"></stop>
    </linearGradient>
    <linearGradient id="paint1_linear_223_20549" x1="27.7504" y1="38.5651" x2="37.7794" y2="35.8778" gradientUnits="userSpaceOnUse">
      <stop stop-color="white"></stop>
      <stop offset="1" stop-color="white" stop-opacity="0"></stop>
    </linearGradient>
    <linearGradient id="paint2_linear_223_20549" x1="52.5591" y1="28.749" x2="59.9202" y2="21.3879" gradientUnits="userSpaceOnUse">
      <stop stop-color="#8B451C"></stop>
      <stop offset="1" stop-color="#8B451C" stop-opacity="0"></stop>
    </linearGradient>
    <linearGradient id="paint3_linear_223_20549" x1="53.8985" y1="9.15679" x2="45.3268" y2="41.1486" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FFC538"></stop>
      <stop offset="1" stop-color="#F7E041"></stop>
    </linearGradient>
    <linearGradient id="paint4_linear_223_20549" x1="40.6795" y1="9.27632" x2="40.0292" y2="31.1259" gradientUnits="userSpaceOnUse">
      <stop stop-color="white"></stop>
      <stop offset="1" stop-color="white" stop-opacity="0"></stop>
    </linearGradient>
    <linearGradient id="paint5_linear_223_20549" x1="-0.69883" y1="64.5542" x2="64.3354" y2="-0.480112" gradientUnits="userSpaceOnUse">
      <stop stop-color="#E37A34"></stop>
      <stop offset="0.5493" stop-color="#FFA538"></stop>
      <stop offset="0.9892" stop-color="#FFC538"></stop>
    </linearGradient>
    <linearGradient id="paint6_linear_223_20549" x1="-1.09859" y1="64.1541" x2="63.9357" y2="-0.880218" gradientUnits="userSpaceOnUse">
      <stop stop-color="#E37A34"></stop>
      <stop offset="0.5493" stop-color="#FFA538"></stop>
      <stop offset="0.9892" stop-color="#FFC538"></stop>
    </linearGradient>
    <linearGradient id="paint7_linear_223_20549" x1="49.7736" y1="24.307" x2="31.0977" y2="29.3112" gradientUnits="userSpaceOnUse">
      <stop stop-color="#E37A34"></stop>
      <stop offset="1" stop-color="#F7E041"></stop>
    </linearGradient>
    <linearGradient id="paint8_linear_223_20549" x1="26.2047" y1="21.9673" x2="51.4827" y2="15.1941" gradientUnits="userSpaceOnUse">
      <stop stop-color="#BA5C25"></stop>
      <stop offset="1" stop-color="#FFA538"></stop>
    </linearGradient>
    <linearGradient id="paint9_linear_223_20549" x1="-10.9788" y1="151.221" x2="40.626" y2="137.394" gradientUnits="userSpaceOnUse">
      <stop stop-color="#BA5C25"></stop>
      <stop offset="0.2216" stop-color="#FFC538"></stop>
      <stop offset="0.3753" stop-color="#FFA538"></stop>
      <stop offset="0.5003" stop-color="#FBC23C"></stop>
      <stop offset="0.6256" stop-color="#F8D840"></stop>
      <stop offset="0.7058" stop-color="#F7E041"></stop>
      <stop offset="0.7857" stop-color="#F9D53F"></stop>
      <stop offset="0.9265" stop-color="#FDB73B"></stop>
      <stop offset="1" stop-color="#FFA538"></stop>
    </linearGradient>
    <linearGradient id="paint10_linear_223_20549" x1="28.9994" y1="132.209" x2="11.9813" y2="136.769" gradientUnits="userSpaceOnUse">
      <stop stop-color="white"></stop>
      <stop offset="1" stop-color="white" stop-opacity="0"></stop>
    </linearGradient>
    <linearGradient id="paint11_linear_223_20549" x1="-15.3719" y1="182.112" x2="-0.826534" y2="127.825" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FFC538"></stop>
      <stop offset="1" stop-color="#F7E041"></stop>
    </linearGradient>
    <linearGradient id="paint12_linear_223_20549" x1="7.06059" y1="181.909" x2="8.16405" y2="144.832" gradientUnits="userSpaceOnUse">
      <stop stop-color="white"></stop>
      <stop offset="1" stop-color="white" stop-opacity="0"></stop>
    </linearGradient>
    <linearGradient id="paint13_linear_223_20549" x1="77.275" y1="88.1078" x2="-33.0818" y2="198.465" gradientUnits="userSpaceOnUse">
      <stop stop-color="#E37A34"></stop>
      <stop offset="0.5493" stop-color="#FFA538"></stop>
      <stop offset="0.9892" stop-color="#FFC538"></stop>
    </linearGradient>
    <linearGradient id="paint14_linear_223_20549" x1="77.9538" y1="88.7865" x2="-32.4032" y2="199.143" gradientUnits="userSpaceOnUse">
      <stop stop-color="#E37A34"></stop>
      <stop offset="0.5493" stop-color="#FFA538"></stop>
      <stop offset="0.9892" stop-color="#FFC538"></stop>
    </linearGradient>
    <linearGradient id="paint15_linear_223_20549" x1="-8.371" y1="156.403" x2="23.3201" y2="147.911" gradientUnits="userSpaceOnUse">
      <stop stop-color="#E37A34"></stop>
      <stop offset="1" stop-color="#F7E041"></stop>
    </linearGradient>
    <linearGradient id="paint16_linear_223_20549" x1="31.6227" y1="160.373" x2="-11.2716" y2="171.867" gradientUnits="userSpaceOnUse">
      <stop stop-color="#BA5C25"></stop>
      <stop offset="1" stop-color="#FFA538"></stop>
    </linearGradient>
  </defs>
</svg>
                    </div>
                    <div class="gx-comp-el-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="74" height="190" viewBox="0 0 74 190" fill="none">
  <g style="mix-blend-mode:luminosity">
    <path d="M14.0301 7.85745L8.88803 13.0144C6.48885 15.4867 5.6589 19.2991 6.93227 24.0516C9.77842 34.6733 22.0283 45.948 34.2932 49.2344C41.2353 51.0945 46.6922 49.9946 49.6068 46.7652L54.5611 41.8216L14.0301 7.85745Z" fill="url(#paint0_linear_223_20572)"></path>
    <path d="M21.8625 29.3695L16.47 21.6815L8.98443 29.167C10.3733 31.7908 12.2447 34.37 14.4581 36.7738L21.8625 29.3695Z" fill="url(#paint1_linear_223_20572)"></path>
    <path d="M37.5825 49.9128C42.9555 50.6753 47.1702 49.4653 49.6069 46.7654L54.5612 41.8218L43.6996 43.7958L37.5825 49.9128Z" fill="url(#paint2_linear_223_20572)"></path>
    <path d="M29.1601 5.58902C16.8952 2.30264 9.25969 8.24915 12.1058 18.8709C14.952 29.4926 27.2017 40.7673 39.4666 44.0536C51.7315 47.34 59.367 41.3935 56.5209 30.7717C53.6747 20.15 41.425 8.87539 29.1601 5.58902Z" fill="url(#paint3_linear_223_20572)"></path>
    <path d="M12.1058 18.8708C14.9518 29.4925 27.2017 40.7673 39.4666 44.0536C42.5257 44.8733 45.2969 45.1184 47.6891 44.86L22.8056 4.68432C14.407 4.68929 9.79177 10.2345 12.1058 18.8708Z" fill="url(#paint4_linear_223_20572)"></path>
    <path d="M40.4635 20.0316C40.0294 19.632 39.5843 19.2521 39.1311 18.8927C38.031 18.0201 37.0942 17.9982 36.7601 18.8181L36.3221 19.8924C36.0905 20.4608 36.6237 21.7002 37.3877 22.401C37.3929 22.4057 37.3979 22.4103 37.4031 22.4151C40.1407 24.9348 40.9767 28.0548 39.2703 29.3837C37.5638 30.7127 33.9612 29.7474 31.2235 27.2276C28.4859 24.7079 27.6499 21.5879 29.3563 20.2589C29.3588 20.2571 29.3611 20.2552 29.3636 20.2534C29.7218 19.9767 29.4672 18.9686 28.8357 18.206L27.4324 16.5112C26.5981 15.5036 25.6821 15.0047 25.1549 15.2837C24.9036 15.4165 24.6668 15.5684 24.4464 15.74C21.0498 18.3853 22.7139 24.5956 28.1632 29.6112C33.6125 34.6268 40.7836 36.5482 44.1802 33.903C47.5769 31.2575 45.9128 25.0471 40.4635 20.0316Z" fill="url(#paint5_linear_223_20572)"></path>
    <path d="M45.0809 16.436C35.5408 7.6554 22.9866 4.29151 17.0402 8.92255C11.0938 13.5536 14.007 24.4259 23.547 33.2065C33.0871 41.9871 45.6414 45.351 51.5878 40.72C57.5341 36.089 54.6209 25.2166 45.0809 16.436ZM48.9672 38.3081C43.9228 42.2365 33.2732 39.383 25.1804 31.9345C17.0878 24.4859 14.6165 15.263 19.6608 11.3346C24.7051 7.40619 35.3548 10.2598 43.4475 17.7083C51.5401 25.1567 54.0114 34.3795 48.9672 38.3081Z" fill="url(#paint6_linear_223_20572)"></path>
    <path d="M49.2556 38.0684C49.1618 38.1502 49.0662 38.2306 48.9664 38.3082C43.9221 42.2366 33.2724 39.3831 25.1797 31.9346C17.6596 25.0131 14.9949 16.5604 18.7028 12.2466C14.0487 16.2997 16.5789 25.3053 24.5117 32.6066C32.6044 40.0551 43.2541 42.9087 48.2984 38.9802C48.6553 38.7023 48.9733 38.3969 49.2556 38.0684Z" fill="url(#paint7_linear_223_20572)"></path>
    <path d="M17.0393 8.92267C16.6401 9.23346 16.2824 9.57328 15.9623 9.93778C16.0942 9.82034 16.2294 9.70512 16.3712 9.59459C22.3176 4.96355 34.872 8.32748 44.412 17.1081C53.3118 25.2995 56.4431 35.3103 51.9959 40.377C57.3889 35.5704 54.3924 25.0073 45.08 16.4362C35.54 7.65555 22.9858 4.29166 17.0393 8.92267Z" fill="url(#paint8_linear_223_20572)"></path>
  </g>
  <g style="mix-blend-mode:luminosity" filter="url(#filter0_f_223_20572)">
    <path d="M93.0424 159.63L91.5765 154.191C90.8482 151.627 88.6152 149.597 84.9388 148.611C76.7221 146.41 64.4308 150.255 57.4853 157.201C53.554 161.132 52.1802 165.213 53.2164 168.415L54.612 173.646L93.0424 159.63Z" fill="url(#paint9_linear_223_20572)"></path>
    <path d="M75.6014 156.557L82.8376 155.918L80.7181 148.008C78.4231 147.923 75.9714 148.179 73.5049 148.733L75.6014 156.557Z" fill="url(#paint10_linear_223_20572)"></path>
    <path d="M55.759 159.142C53.17 162.447 52.3505 165.738 53.2168 168.415L54.6123 173.646L57.491 165.606L55.759 159.142Z" fill="url(#paint11_linear_223_20572)"></path>
    <path d="M88.7103 170.644C95.6558 163.698 94.6254 156.283 86.4087 154.081C78.192 151.88 65.9008 155.725 58.9553 162.671C52.0098 169.616 53.0402 177.032 61.2569 179.233C69.4736 181.435 81.7648 177.589 88.7103 170.644Z" fill="url(#paint12_linear_223_20572)"></path>
    <path d="M86.4088 154.081C78.1922 151.879 65.9008 155.725 58.9553 162.671C57.2229 164.403 55.9869 166.165 55.2347 167.867L91.7742 166.736C95.0193 161.108 93.0895 155.871 86.4088 154.081Z" fill="url(#paint13_linear_223_20572)"></path>
    <path d="M74.6626 172.63C75.0982 172.494 75.5249 172.342 75.941 172.178C76.951 171.778 77.328 171.159 76.908 170.618L76.3576 169.909C76.0665 169.534 75.03 169.412 74.265 169.653C74.2598 169.655 74.2547 169.656 74.2496 169.658C71.5026 170.517 69.0892 169.871 68.8588 168.213C68.6285 166.556 70.6687 164.516 73.4157 163.657C76.1626 162.797 78.5761 163.444 78.8064 165.101C78.8067 165.103 78.807 165.106 78.8073 165.108C78.8541 165.455 79.628 165.674 80.3831 165.546L82.0612 165.262C83.059 165.092 83.7475 164.672 83.7645 164.211C83.7727 163.991 83.7626 163.774 83.7328 163.56C83.2744 160.261 78.4703 158.974 73.0025 160.684C67.5347 162.395 63.4738 166.456 63.9322 169.755C64.3907 173.053 69.1949 174.341 74.6626 172.63Z" fill="url(#paint14_linear_223_20572)"></path>
    <path d="M75.2858 177.114C84.8582 174.119 91.9675 167.009 91.165 161.234C90.3625 155.459 81.9521 153.206 72.3797 156.201C62.8074 159.196 55.698 166.305 56.5005 172.08C57.303 177.855 65.7135 180.108 75.2858 177.114ZM59.1299 171.257C58.4492 166.358 64.48 160.328 72.6001 157.787C80.7203 155.247 87.8548 157.158 88.5355 162.057C89.2162 166.956 83.1854 172.987 75.0653 175.527C66.9452 178.068 59.8107 176.156 59.1299 171.257Z" fill="url(#paint15_linear_223_20572)"></path>
    <path d="M59.1788 171.543C59.1603 171.449 59.1435 171.354 59.13 171.257C58.4493 166.358 64.4801 160.327 72.6002 157.787C80.1458 155.426 86.8392 156.91 88.295 161.063C87.3798 156.377 80.3681 154.589 72.4084 157.079C64.2883 159.62 58.2575 165.651 58.9382 170.549C58.9863 170.896 59.0679 171.227 59.1788 171.543Z" fill="url(#paint16_linear_223_20572)"></path>
    <path d="M91.1653 161.234C91.1115 160.846 91.0222 160.475 90.9018 160.12C90.9295 160.254 90.9544 160.389 90.9736 160.526C91.7761 166.301 84.6666 173.411 75.0943 176.406C66.1643 179.2 58.2467 177.425 56.5724 172.486C57.7065 177.958 65.9421 180.037 75.2861 177.113C84.8584 174.118 91.9678 167.009 91.1653 161.234Z" fill="url(#paint17_linear_223_20572)"></path>
  </g>
  <defs>
    <filter id="filter0_f_223_20572" x="48.8837" y="143.991" width="48.4301" height="39.8623" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
      <feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood>
      <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"></feBlend>
      <feGaussianBlur stdDeviation="2" result="effect1_foregroundBlur_223_20572"></feGaussianBlur>
    </filter>
    <linearGradient id="paint0_linear_223_20572" x1="35.6837" y1="40.4982" x2="5.8682" y2="10.6826" gradientUnits="userSpaceOnUse">
      <stop stop-color="#BA5C25"></stop>
      <stop offset="0.2216" stop-color="#FFC538"></stop>
      <stop offset="0.3753" stop-color="#FFA538"></stop>
      <stop offset="0.5003" stop-color="#FBC23C"></stop>
      <stop offset="0.6256" stop-color="#F8D840"></stop>
      <stop offset="0.7058" stop-color="#F7E041"></stop>
      <stop offset="0.7857" stop-color="#F9D53F"></stop>
      <stop offset="0.9265" stop-color="#FDB73B"></stop>
      <stop offset="1" stop-color="#FFA538"></stop>
    </linearGradient>
    <linearGradient id="paint1_linear_223_20572" x1="6.91186" y1="20.6753" x2="16.7444" y2="30.5079" gradientUnits="userSpaceOnUse">
      <stop stop-color="white"></stop>
      <stop offset="1" stop-color="white" stop-opacity="0"></stop>
    </linearGradient>
    <linearGradient id="paint2_linear_223_20572" x1="34.9098" y1="42.8764" x2="48.3768" y2="46.4849" gradientUnits="userSpaceOnUse">
      <stop stop-color="#8B451C"></stop>
      <stop offset="1" stop-color="#8B451C" stop-opacity="0"></stop>
    </linearGradient>
    <linearGradient id="paint3_linear_223_20572" x1="58.5302" y1="31.3103" x2="15.6849" y2="42.7912" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FFC538"></stop>
      <stop offset="1" stop-color="#F7E041"></stop>
    </linearGradient>
    <linearGradient id="paint4_linear_223_20572" x1="49.5399" y1="16.0582" x2="23.7623" y2="29.9352" gradientUnits="userSpaceOnUse">
      <stop stop-color="white"></stop>
      <stop offset="1" stop-color="white" stop-opacity="0"></stop>
    </linearGradient>
    <linearGradient id="paint5_linear_223_20572" x1="-42.282" y1="5.08175" x2="76.6966" y2="36.962" gradientUnits="userSpaceOnUse">
      <stop stop-color="#E37A34"></stop>
      <stop offset="0.5493" stop-color="#FFA538"></stop>
      <stop offset="0.9892" stop-color="#FFC538"></stop>
    </linearGradient>
    <linearGradient id="paint6_linear_223_20572" x1="-42.0853" y1="4.35012" x2="76.8933" y2="36.2304" gradientUnits="userSpaceOnUse">
      <stop stop-color="#E37A34"></stop>
      <stop offset="0.5493" stop-color="#FFA538"></stop>
      <stop offset="0.9892" stop-color="#FFC538"></stop>
    </linearGradient>
    <linearGradient id="paint7_linear_223_20572" x1="38.1958" y1="36.6709" x2="19.8857" y2="18.3609" gradientUnits="userSpaceOnUse">
      <stop stop-color="#E37A34"></stop>
      <stop offset="1" stop-color="#F7E041"></stop>
    </linearGradient>
    <linearGradient id="paint8_linear_223_20572" x1="25.1271" y1="7.76788" x2="49.9101" y2="32.5507" gradientUnits="userSpaceOnUse">
      <stop stop-color="#BA5C25"></stop>
      <stop offset="1" stop-color="#FFA538"></stop>
    </linearGradient>
    <linearGradient id="paint9_linear_223_20572" x1="62.8001" y1="161.512" x2="94.3066" y2="153.069" gradientUnits="userSpaceOnUse">
      <stop stop-color="#BA5C25"></stop>
      <stop offset="0.2216" stop-color="#FFC538"></stop>
      <stop offset="0.3753" stop-color="#FFA538"></stop>
      <stop offset="0.5003" stop-color="#FBC23C"></stop>
      <stop offset="0.6256" stop-color="#F8D840"></stop>
      <stop offset="0.7058" stop-color="#F7E041"></stop>
      <stop offset="0.7857" stop-color="#F9D53F"></stop>
      <stop offset="0.9265" stop-color="#FDB73B"></stop>
      <stop offset="1" stop-color="#FFA538"></stop>
    </linearGradient>
    <linearGradient id="paint10_linear_223_20572" x1="87.2086" y1="149.904" x2="76.8184" y2="152.688" gradientUnits="userSpaceOnUse">
      <stop stop-color="white"></stop>
      <stop offset="1" stop-color="white" stop-opacity="0"></stop>
    </linearGradient>
    <linearGradient id="paint11_linear_223_20572" x1="61.5067" y1="160.073" x2="53.8804" y2="167.699" gradientUnits="userSpaceOnUse">
      <stop stop-color="#8B451C"></stop>
      <stop offset="1" stop-color="#8B451C" stop-opacity="0"></stop>
    </linearGradient>
    <linearGradient id="paint12_linear_223_20572" x1="60.1189" y1="180.371" x2="68.9994" y2="147.227" gradientUnits="userSpaceOnUse">
      <stop stop-color="#FFC538"></stop>
      <stop offset="1" stop-color="#F7E041"></stop>
    </linearGradient>
    <linearGradient id="paint13_linear_223_20572" x1="73.8141" y1="180.247" x2="74.4878" y2="157.611" gradientUnits="userSpaceOnUse">
      <stop stop-color="white"></stop>
      <stop offset="1" stop-color="white" stop-opacity="0"></stop>
    </linearGradient>
    <linearGradient id="paint14_linear_223_20572" x1="116.683" y1="122.979" x2="49.306" y2="190.355" gradientUnits="userSpaceOnUse">
      <stop stop-color="#E37A34"></stop>
      <stop offset="0.5493" stop-color="#FFA538"></stop>
      <stop offset="0.9892" stop-color="#FFC538"></stop>
    </linearGradient>
    <linearGradient id="paint15_linear_223_20572" x1="117.097" y1="123.393" x2="49.7204" y2="190.77" gradientUnits="userSpaceOnUse">
      <stop stop-color="#E37A34"></stop>
      <stop offset="0.5493" stop-color="#FFA538"></stop>
      <stop offset="0.9892" stop-color="#FFC538"></stop>
    </linearGradient>
    <linearGradient id="paint16_linear_223_20572" x1="64.3928" y1="164.675" x2="83.7413" y2="159.49" gradientUnits="userSpaceOnUse">
      <stop stop-color="#E37A34"></stop>
      <stop offset="1" stop-color="#F7E041"></stop>
    </linearGradient>
    <linearGradient id="paint17_linear_223_20572" x1="88.8107" y1="167.099" x2="62.6222" y2="174.116" gradientUnits="userSpaceOnUse">
      <stop stop-color="#BA5C25"></stop>
      <stop offset="1" stop-color="#FFA538"></stop>
    </linearGradient>
  </defs>
</svg>
                    </div>
                    <div class="gx-floating-remark"><svg width="18" height="18" viewBox="0 0 18 18" fill="none" class="ic_login_warn">
<path d="M9 16.5C13.14 16.5 16.5 13.14 16.5 9C16.5 4.86 13.14 1.5 9 1.5C4.86 1.5 1.5 4.86 1.5 9C1.5 13.14 4.86 16.5 9 16.5ZM9.75 6V9C9.75 9.41421 9.41421 9.75 9 9.75C8.58579 9.75 8.25 9.41421 8.25 9V6C8.25 5.58579 8.58579 5.25 9 5.25C9.41421 5.25 9.75 5.58579 9.75 6ZM9.93738 11.8125V12.1874C9.93738 12.6016 9.6016 12.9374 9.18738 12.9374H8.81246C8.39825 12.9374 8.06246 12.6016 8.06246 12.1874V11.8125C8.06246 11.3983 8.39825 11.0625 8.81246 11.0625H9.18738C9.6016 11.0625 9.93738 11.3983 9.93738 11.8125Z" fill="#F1AC44"></path>
</svg>
Создание более 1 аккаунта запрещено!</div>
                </div>
                <div class="gx-col gx-right">
                    <div class="popup__title d-flex align-center justify-space-between text-f18">
                        <span>Авторизация</span>
                        <a href="#" class="close d-flex align-center justify-center">
                            <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
                        </a>
                    </div>
                    <div class="popup__content">
                        <p class="text-gray">Выберите способ авторизации:</p><br>
                        <div class="auth_blocks">
                            <a href="/vk_auth" style="background: #1983FF;" class="btn btn--blue d-flex align-center justify-center is-ripples flare">
                            <span class="login_buttons">
                                <svg width="16" height="17" viewBox="0 0 16 17" fill="none" class="ic_login">
<path d="M8.728 13.5C3.26109 13.5 0.146781 9.74653 0 3.5H2.73741C2.82469 8.0845 4.84403 10.0248 6.44284 10.4264V3.5H9.02156V7.45228C10.6085 7.28528 12.2589 5.46422 12.8182 3.5H15.393C15.1841 4.52655 14.7662 5.49915 14.1654 6.35734C13.5651 7.21486 12.7945 7.93951 11.9018 8.48609C12.9006 8.98358 13.7823 9.68767 14.4884 10.5517C15.1951 11.4165 15.7103 12.4214 16 13.5H13.1634C12.5564 11.5994 11.0369 10.1282 9.0295 9.92147V13.5H8.728Z" fill="white"></path>
</svg>
ВКонтакте</span>
</a>
                            <a href="/tg_auth" style="background: #3995FC;" class="btn btn--blue d-flex align-center justify-center is-ripples flare">
                            <span class="login_buttons">
                            <svg width="16" height="17" viewBox="0 0 16 17" fill="none" class="ic_login">
<path d="M1.79462 7.66153C1.79462 7.66153 8.42877 4.80779 10.7296 3.80291C11.6116 3.401 14.6027 2.11476 14.6027 2.11476C14.6027 2.11476 15.9833 1.55207 15.8682 2.91864C15.8298 3.48138 15.5231 5.45085 15.2163 7.58115C14.7561 10.5957 14.2576 13.8916 14.2576 13.8916C14.2576 13.8916 14.1809 14.8161 13.529 14.9768C12.8771 15.1376 11.8033 14.4142 11.6116 14.2533C11.4582 14.1328 8.73553 12.324 7.7385 11.4398C7.47005 11.1986 7.16329 10.7163 7.77682 10.1536C9.15735 8.82717 10.8063 7.17923 11.8033 6.13419C12.2635 5.65184 12.7237 4.52642 10.8063 5.89299C8.08363 7.86252 5.3993 9.71144 5.3993 9.71144C5.3993 9.71144 4.78572 10.1134 3.63531 9.7516C2.48484 9.38991 1.14267 8.90755 1.14267 8.90755C1.14267 8.90755 0.222386 8.30465 1.79462 7.66153Z" fill="white"></path>
</svg>Telegram</span></a>
                            <a href="/yandex_auth" style="background: #C7503B;" class="btn btn--red d-flex align-center justify-center is-ripples flare"><span class="login_buttons">
                            <svg width="16" height="17" viewBox="0 0 16 17" fill="none" class="ic_login">
<g clip-path="url(#clip0_222_11190)">
<path d="M11.344 0.5H9.07075C6.76759 0.5 4.44368 2.20069 4.44368 6.00019C4.44368 7.96825 5.27784 9.50106 6.80684 10.3728L4.00825 15.4381C3.87559 15.6777 3.87215 15.9492 3.999 16.1643C4.12284 16.3745 4.34925 16.5 4.60459 16.5H6.02015C6.34175 16.5 6.59253 16.3446 6.71275 16.0723L9.33668 10.94H9.52818V15.8603C9.52818 16.2071 9.82078 16.5 10.1671 16.5H11.4038C11.7922 16.5 12.0634 16.2288 12.0634 15.8405V1.20009C12.0634 0.787906 11.7677 0.5 11.344 0.5ZM9.52825 8.66019H9.19043C7.88059 8.66019 7.09859 7.591 7.09859 5.80009C7.09859 3.57325 8.08643 2.77984 9.01093 2.77984H9.52825V8.66019Z" fill="white"></path>
</g>
<defs>
<clipPath id="clip0_222_11190">
<rect width="16" height="16" fill="white" transform="translate(0 0.5)"></rect>
</clipPath>
</defs>
</svg>Яндекс</span></a>
                            <a href="/google_auth" style="" class="btn d-flex btn--gray align-center justify-center is-ripples flare"><span class="login_buttons">
                            <svg width="16" height="17" viewBox="0 0 16 17" fill="none" class="ic_login">
<g clip-path="url(#clip0_222_11207)">
<path d="M8 7.04547V10.1437H12.3055C12.1164 11.14 11.5491 11.9837 10.6982 12.551L13.2945 14.5656C14.8073 13.1692 15.68 11.1183 15.68 8.68192C15.68 8.11466 15.6291 7.56915 15.5345 7.04556L8 7.04547Z" fill="#4285F4"></path>
<path d="M3.51675 10.0227L2.93117 10.471L0.858398 12.0855C2.17477 14.6964 4.87276 16.5001 8.00003 16.5001C10.16 16.5001 11.9709 15.7874 13.2946 14.5656L10.6982 12.551C9.98546 13.031 9.07635 13.3219 8.00003 13.3219C5.92003 13.3219 4.1528 11.9183 3.52002 10.0274L3.51675 10.0227Z" fill="#34A853"></path>
<path d="M0.858124 4.91457C0.312696 5.9909 0 7.20547 0 8.5C0 9.79453 0.312696 11.0091 0.858124 12.0854C0.858124 12.0927 3.52 10.02 3.52 10.02C3.36 9.53996 3.26543 9.0309 3.26543 8.49992C3.26543 7.96893 3.36 7.45987 3.52 6.97987L0.858124 4.91457Z" fill="#FBBC05"></path>
<path d="M8.00019 3.68547C9.1784 3.68547 10.2257 4.09273 11.062 4.8782L13.3529 2.58731C11.9638 1.29278 10.1602 0.5 8.00019 0.5C4.87293 0.5 2.17477 2.29637 0.858398 4.91458L3.5202 6.98004C4.15289 5.0891 5.92019 3.68547 8.00019 3.68547Z" fill="#EA4335"></path>
</g>
<defs>
<clipPath id="clip0_222_11207">
<rect width="15.68" height="16" fill="white" transform="translate(0 0.5)"></rect>
</clipPath>
</defs>
</svg>
                            Google</span></a>
                        </div>
						<br>
                        <p class="gx-remark">Посещая сайт, Вы подтверждаете, что достигли совершеннолетия и ознакомились с условиями предоставления услуг и политикой конфиденциальности.</p>
                    </div>
                </div>
            </div>
        </div>
        
        @endguest
       
        <div class="popup popup--crash-info">
            <div class="popup__title d-flex align-center justify-space-between">
                <span>Режим «Crash»</span>
                <a href="#" class="close d-flex align-center justify-center">
                    <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
                </a>
            </div>
            <div class="popup__content">
                <p>Crash - онлайн игра, и как и все онлайн игры имеет недостатки, связанные с сетью</p>
                <div class="text__borders"></div>
                <p>Быстродействие выполнения ручного вывода (кнопка "Вывести деньги"), отображение графика на странице, напрямую зависят от следующих факторов:</p>
                <ol class="show_ul">
                    <li>Скорость Вашего интернет соединения</li>
                    <li>Пинг до сервера (Latency / Задержка)</li>
                    <li>Мощность смартфона или компьютера (используется для обработки данных графика и его показа)</li>
                    <li>Время ответа от нашего сервера</li>
                </ol>


                <div class="text__borders"></div>
                <p> 
                    Сервис не гарантирует своевременного выполнения ручного вывода после нажатия (кнопка "Вывести деньги") и настоятельно рекомендует использовать функцию автоматического вывода средств (поле "Автовывод").
                </p>
                <div class="text__borders"></div>
                <p>
                Функция "Автовывод" используется на стороне сервера, что снижает риск проблем, связанных с своевременным выводом, на 99.9%</p>
                <br>
                <div class="bx-input">
                    <a onclick="localStorage.setItem('crashAgree', 'true');;$('.close').click()" class="btn btn--red d-flex align-center justify-center is-ripples flare"><span>Я ознакомлен. Закрыть</span></a>
                </div>

            </div>
        </div>

        @auth
        <div class="popup popup--demo-add">
            <div class="popup__title d-flex align-center justify-space-between">
                <div class="popup__tabs d-flex align-center">
                    <div class="popup__tab popup__tab--active d-flex align-center">
                        <svg class="icon"><use xlink:href="images/symbols.svg#plus"></use></svg>
                        <span>Пополнение демо баланса</span>
                    </div>
                    
                </div>
                <a href="#" class="close d-flex align-center justify-center">
                    <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
                </a>
            </div>
            <div class="popup__content">
                <div class="wallet  d-flex align-stretch justify-space-between flex-wrap">



                    <div class="wallet__content d-flex flex-column justify-space-between" style="width:100%">
                        <div class="wallet__content-top">
                           <div class="bx-input d-flex flex-column">
                            <div class="bx-input__input d-flex align-center justify-space-between">
                                <label class="d-flex align-center">Сумма пополнения:</label>
                                <div class="d-flex align-center">
                                    <input type="text" id="add_balance"  placeholder="0.00">
                                    <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg>
                                </div>
                            </div>
                        </div>


                    </div>
                    <div class="wallet__content-bottom" style="margin-top:10px;">
                        <div class="wallet__order d-flex justify-space-between align-center">
                            <div class="wallet__txt d-flex flex-column">

                                <b class="d-flex align-center">Всего к оплате: <span class="d-flex align-center"><b class="">0</b> <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg></span></b>
                            </div>
                            <a onclick="addDemoBalance()" class="btn is-ripples flare btn--blue d-flex align-center"><span>ПОПОЛНИТЬ</span></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="popup popup--wallet">
        <div class="popup__title d-flex align-center justify-space-between">
            <div class="popup__tabs d-flex align-center">
                <div class="popup__tab popup__tab--active d-flex align-center">
                    <svg class="icon"><use xlink:href="images/symbols.svg#plus"></use></svg>
                    <span>Пополнение</span>
                </div>
                <div class="popup__tab d-flex align-center">
                    <svg class="icon"><use xlink:href="images/symbols.svg#minus"></use></svg>
                    <span>Вывод</span>
                </div>
                <div class="popup__tab d-flex align-center">
                    <svg class="icon"><use xlink:href="images/symbols.svg#timer"></use></svg>
                    <span>История</span>
                </div>
            </div>
            <a href="#" class="close d-flex align-center justify-center">
                <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
            </a>
        </div>
        <script type="text/javascript">
            function setSystemDep(id){
                $('#systemDep').val(id)
            }
        </script>
        <div class="popup__content">
            <div class="wallet wallet--refill d-flex align-stretch justify-space-between flex-wrap">
                <div class="wallet__methods">
                    <div class="wallet__scroll" ss-container>
                        @php
                        $systemDeps = \App\SystemDep::orderBy('sort', 'asc')->orderBy('id', 'asc')->where('off', 0)->get();

                        @endphp
                        @foreach($systemDeps as $s)

                        <div onclick="setSystemDep({{$s->id}})" class="wallet__method wallet__method--sort-{{$s->sort}}_DEPOSIT wallet__method--{{$s->id}}_DEPOSIT d-flex align-center">
                            <img src="{{$s->img}}">
                            <div class="d-flex flex-column">
                                <span>{{$s->name}}</span>
                                <b>{{$s->comm_percent}}%</b>
                            </div>
                        </div>

                        @endforeach

                    </div>
                </div>

                <input type="hidden" id="systemDep" name="">
                <div class="wallet__content d-flex flex-column justify-space-between">
                    <div class="wallet__content-top">
                        <div class="bx-input d-flex flex-column">
                            <div class="bx-input__input d-flex align-center justify-space-between">                       
                                    <input type="text" style="text-align: left;" id="sumDep" onkeyup="$('.payDep').html($('#sumDep').val())" placeholder="ВВЕДИТЕ СУММУ">
                                    <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg>
                            </div>
                        </div>
                        
                    <div class="x30__bet-placed d-flex align-center justify-space-between payments">
                        <a onclick="$('#sumDep').val((Number($('#sumDep').val()) + 10).toFixed(2));">+10</a>
                        <a onclick="$('#sumDep').val((Number($('#sumDep').val()) + 100).toFixed(2));">+100</a>
                        <a onclick="$('#sumDep').val((Number($('#sumDep').val()) + 1000).toFixed(2));">+1000</a>
                        <a onclick="$('#sumDep').val((Number($('#sumDep').val()) * 2).toFixed(2));">x2</a>
                        <a onclick="$('#sumDep').val(Math.max((Number($('#sumDep').val()) / 2), 1).toFixed(2));">1/2</a>
                    </div> 

                        <div class="bx-input d-flex flex-column">
                            <div class="bx-input__input d-flex align-center justify-space-between">
                                <input type="text" style="text-align: left;" id="promoDep" placeholder="ВВЕДИТЕ ПРОМОКОД">
                            </div>
                        </div>

                        <div class="d-flex align-center justify-space-between">
                            <div class="wallet__txt"><span class="d-flex align-center">Комиссия: 0%</span></div>
                        </div>
                    </div>
                    <div class="wallet__content-bottom">
                        <div class="wallet__order d-flex justify-space-between align-center">
                            <div class="wallet__txt d-flex flex-column">
                                
                                <b class="d-flex align-center">Всего к оплате: <span class="d-flex align-center"><b class="payDep">0</b> <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg></span></b>
                            </div>
                            <a onclick="disable(this);goDeposit(this)" class="btn is-ripples flare btn--blue d-flex align-center"><span>ПОПОЛНИТЬ</span></a>
                        </div>
                    </div>
                </div>
            </div>
            <script type="text/javascript">
                
            </script>
            <script type="text/javascript">
                function setSystemW(id, comm_percent, comm_rub, min_sum){
                    $('#systemW').val(id)
                    $('#min_sum_withdraws').html(min_sum)
                    $('#comm_percent').val(comm_percent)
                    $('#comm_rub').val(comm_rub)
                    updateW()
                }
            </script>
            <div class="wallet wallet--withdraw d-flex align-stretch justify-space-between flex-wrap">
                <div class="wallet__methods">
                    <div class="wallet__scroll" ss-container>
                     @php
                     $SystemWithraws = \App\SystemWithdraw::all();

                     @endphp
                     @foreach($SystemWithraws as $s)

                     <div onclick="setSystemW({{$s->id}}, {{$s->comm_percent}}, {{$s->comm_rub}}, {{$s->min_sum}})" class="W wallet__method wallet__method--{{$s->name}}_WITHDRAW d-flex align-center">
                        <img src="{{$s->img}}">
                        <div class="d-flex flex-column">
                            <span>{{$s->name}}</span>
                            <b>{{$s->comm_percent}}% @if($s->comm_rub > 0) + {{$s->comm_rub}}P  @endif</b>
                        </div>
                    </div>

                    @endforeach
                </div>
            </div>
            <input type="hidden" id="systemW" name="">
            <input type="hidden" id="comm_rub" name="">
            <input type="hidden" id="comm_percent" name="">
            <div class="wallet__content d-flex flex-column justify-space-between">
                <div class="wallet__content-top">
                    <div class="bx-input d-flex flex-column">
                        <div class="bx-input__input d-flex align-center justify-space-between">
                            
                                <input type="text" style="text-align: left;" id="sum_withdraw" onkeyup="$('#sum_itog_pay').html($('#sum_withdraw').val());updateW()" placeholder="ВВЕДИТЕ СУММУ ВЫВОДА">
                                <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg>
                            
                        </div>
                    </div>
                    <div class="bx-input d-flex flex-column">
                        <div class="bx-input__input d-flex align-center justify-space-between">
                            <label class="d-flex align-center">Поступит на счёт:</label>
                            <div class="d-flex align-center">
                                <span class="bx-input__text" id="get_withdraw"></span>
                                <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg>
                            </div>
                        </div>
                    </div>
                    <div class="bx-input d-flex flex-column">
                        <div class="bx-input__input d-flex align-center justify-space-between">
                            
                                <input style="text-align: left;"  type="text" id="wallet_withdraw" placeholder="ВВЕДИТЕ РЕКВИЗИТЫ">
                            
                        </div>
                    </div>
                </div>
                <div class="wallet__content-bottom">
                    <div class="wallet__order d-flex justify-space-between align-center">
                        <div class="wallet__txt d-flex flex-column">
                            <span class="d-flex align-center">Мин. вывод: &nbsp;<span id="min_sum_withdraws">50</span> <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg></span>
                            <b class="d-flex align-center">К выводу: <span class="d-flex align-center"><span class="sum_itog_pay" id="sum_itog_pay">100</span> <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg></span></b>
                        </div>
                        <a onclick="disable(this);goWithdraw(this)" class="btn is-ripples flare btn--red d-flex align-center"><span>ВЫВЕСТИ</span></a>
                    </div>
                    <div class="wallet__order d-flex justify-space-between align-center">
                        <div class="wallet__txt d-flex flex-column">
                            <span class="d-flex align-center">Максимальный вывод с бонуса: &nbsp;<span>{{ in_array($u->status, [0, 1]) ? 300 : ($u->status == 2 ? 500 : ($u->status == 3 ? 600 : ($u->status == 4 ? 750 : ($u->status == 5 ? 1000 : 2000)))) }}</span> <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg></span>
                        </div></div>
                    </div>
                </div>
            </div>
            @auth
            <div class="wallet wallet--history d-flex flex-column justify-center align-center">
                <div class="wallet__tabs d-flex align-center">
                    <div class="wallet__tab wallet__tab--active d-flex align-center">
                        <svg class="icon"><use xlink:href="images/symbols.svg#plus"></use></svg>
                        <span>Пополнения</span>
                    </div>
                    <div class="wallet__tab d-flex align-center">
                        <svg class="icon"><use xlink:href="images/symbols.svg#minus"></use></svg>
                        <span>Выводы</span>
                    </div>
                </div>
                <div class="wallet__history wallet__history--refill">
                    @php
                    $deps = \App\Payment::where('user_id', \Auth::user()->id)->orderBy('id', 'desc')->limit(10)->get();

                    @endphp

                    @foreach($deps as $d)
                    <div class="wallet__history-item d-flex justify-space-between align-center">
                        <div class="wallet__history-left d-flex align-center">
                         <div class="wallet__method d-flex align-center">
                            <img src="{{$d->img_system}}">
                            @php
                            $system_dep = \App\SystemDep::where('img', $d->img_system)->first();
                            @endphp
                            <span>@if($system_dep){{$system_dep->name}}@endif</span>
                        </div>
                        <div class="wallet__history-sum d-flex align-center">
                            <span>{{$d->sum}}</span>
                            <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg>
                        </div>
                    </div>
                    <div class="wallet__history-status @if($d->status == 0) warning @else success @endif">
                        <span>@if($d->status == 0) Ожидание... @else Успешно @endif</span>
                    </div>
                </div>

                @endforeach



            </div>
            <div class="wallet__history wallet__history--withdraw">

                @php
                $withdraws = \App\Withdraw::where('user_id', \Auth::user()->id)->orderBy('id', 'desc')->limit(10)->get();

                @endphp

                @foreach($withdraws as $w)
                <div class="wallet__history-item d-flex justify-space-between align-center">
                    <div class="wallet__history-left d-flex align-center">
                        <div class="wallet__method d-flex align-center">
                            <img src="{{$w->img_system}}">
                            @php
                            $system_w = \App\SystemWithdraw::where('img', $w->img_system)->first();
                            @endphp
                            <span>@if($system_w){{$system_w->name}}@endif</span>
                        </div>
                        <div class="wallet__history-sum d-flex align-center">
                            <span>{{$w->sum}}</span>
                            <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg>
                        </div>
                    </div>
                    <div id="statusW_{{$w->id}}" class="wallet__history-status  @if($w->status == 0) warning @elseif($w->status == 2) error @elseif($w->status == 1) success  @elseif($w->status == 3 || $w->status == 4) warning @else error @endif ">
                        <span >@if($w->status == 0) Ожидание... (<a onclick="disable(this);canselWithdraw({{$w->id}}, this)">Отменить</a>)@elseif($w->status == 2) Отменен @elseif($w->status == 1) Успешно  @elseif($w->status == 3) Ожидает отправки @elseif($w->status == 4) Отправлен @else Ошибка @endif</span>
                    </div>
                </div>

                @endforeach
            </div> 
        </div>


        @endauth
        @endauth
    </div>
</div>

@auth
@if(\Auth::user()->admin == 1)
<div class="popup popup--gokeno">
    <div class="popup__title d-flex align-center justify-space-between">
        <div class="popup__tabs d-flex align-center">
            <div class="popup__tab popup__tab--active d-flex align-center">
                <svg class="icon"><use xlink:href="images/symbols.svg#plus"></use></svg>
                <span>Подкрутка кено</span>
            </div>

        </div>
        <a href="#" class="close d-flex align-center justify-center">
            <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
        </a>
    </div>
    <div class="popup__content">
        <div class="wallet  d-flex align-stretch justify-space-between flex-wrap">



            <div class="wallet__content d-flex flex-column justify-space-between" style="width:100%">
                <div class="wallet__content-top">
                    <div class="bx-input d-flex  align-stretch justify-space-between ">
                        <div class="bx-input__input d-flex align-center justify-space-between">
                            <label class="d-flex align-center">Ч-1:</label>
                            <div class="d-flex align-center">
                                <input type="text" id="kenoGo1"   placeholder="0">

                            </div>
                        </div>
                        <div class="bx-input__input d-flex align-center justify-space-between">
                            <label class="d-flex align-center">Ч-2:</label>
                            <div class="d-flex align-center">
                                <input type="text" id="kenoGo2"   placeholder="0">

                            </div>
                        </div>
                        <div class="bx-input__input d-flex align-center justify-space-between">
                           <label class="d-flex align-center">Ч-3:</label>
                           <div class="d-flex align-center">
                            <input type="text" id="kenoGo3"   placeholder="0">

                        </div>
                    </div>

                </div>

                <div class="bx-input d-flex  align-stretch justify-space-between ">
                    <div class="bx-input__input d-flex align-center justify-space-between">
                        <label class="d-flex align-center">Ч-4:</label>
                        <div class="d-flex align-center">
                            <input type="text" id="kenoGo4"   placeholder="0">

                        </div>
                    </div>
                    <div class="bx-input__input d-flex align-center justify-space-between">
                        <label class="d-flex align-center">Ч-5:</label>
                        <div class="d-flex align-center">
                            <input type="text" id="kenoGo5"   placeholder="0">

                        </div>
                    </div>
                    

                </div>            



            </div>
            <div class="wallet__content-bottom" style="margin-top:10px;">
                <div class="wallet__order d-flex justify-space-between align-center">
                    <div class="wallet__txt d-flex flex-column">

                    </div>
                    <a onclick="kenoGo()" class="btn is-ripples flare btn--blue d-flex align-center"><span>Подкрутить</span></a>
                </div>
            </div>

            <div class="text__borders"></div>

            <div class="wallet__content-top">
                <div class="bx-input d-flex  align-stretch justify-space-between ">
                    <div class="bx-input__input d-flex align-center justify-space-between">
                        <label class="d-flex align-center">Номер:</label>
                        <div class="d-flex align-center">
                            <input type="text" id="kenoBonusNumber"   placeholder="0">

                        </div>
                    </div>
                    <div class="bx-input__input d-flex align-center justify-space-between">
                        <label class="d-flex align-center">Икс:</label>
                        <div class="d-flex align-center">
                            <input type="text" id="kenoBonusCoeff"   placeholder="0">

                        </div>
                    </div>


                </div>



            </div>
            <div class="wallet__content-bottom" style="margin-top:10px;">
                <div class="wallet__order d-flex justify-space-between align-center">
                    <div class="wallet__txt d-flex flex-column">

                    </div>
                    <a onclick="kenoGoBonus()" class="btn is-ripples flare btn--blue d-flex align-center"><span>Подкрутить бонуску</span></a>
                </div>
            </div>

        </div>
    </div>
</div>
</div>

<script type="text/javascript">
    function kenoGo(){

        $.post('/keno/go',{_token: csrf_token, 
            kenoGo1: $('#kenoGo1').val(),
            kenoGo2: $('#kenoGo2').val(),
            kenoGo3: $('#kenoGo3').val(),
            kenoGo4: $('#kenoGo4').val(),
            kenoGo5: $('#kenoGo5').val(),
            
            
        }).then(e=>{

            if(e.success){      

                notification('success','Успешно')
            }
            if(e.error){       
                notification('error',e.error)
            }
        }).fail(e=>{
            notification('error',JSON.parse(e.responseText).message)
        })  
    }

    function kenoGoBonus(){

        $.post('/keno/bonusgo',{_token: csrf_token, 
            kenoBonusNumber: $('#kenoBonusNumber').val(),
            kenoBonusCoeff: $('#kenoBonusCoeff').val(),
        }).then(e=>{
            if(e.success){     

                notification('success','Успешно')
            }
            if(e.error){       
                notification('error',e.error)
            }
        }).fail(e=>{
            notification('error',JSON.parse(e.responseText).message)
        })  
    }
</script>
@endif

@endauth




<div class="popup popup--coupon">
    <div class="popup__title d-flex align-center justify-space-between">
        <div class="popup__tabs d-flex align-center">
            <div class="popup__tab popup__tab--active d-flex align-center">
                <svg class="icon"><use xlink:href="images/symbols.svg#plus"></use></svg>
                <span>Промокод</span>
            </div>

        </div>
        <a href="#" class="close d-flex align-center justify-center">
            <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
        </a>
    </div>
    <div class="popup__content">
        <div class="bx-input d-flex align-center justify-space-between promocodeInputBlock">
            <div class="bx-input__input promocodeInput d-flex align-center justify-space-between">
                
                
                    <input type="text" style="text-align: left;" id="promo_name" placeholder="ВВЕДИТЕ ПРОМОКОД">
                    
            </div>

            <a onclick="disable(this);actPromo(this)" class="btn is-ripples flare btn--blue d-flex align-center justify-center promocodeInputBtn"><span>Активировать</span></a>

            
        </div>
        <div class="tournier__separate"></div>
        <div class="bx-input">
            <div class="bx-input__create-coupon">
                <div class="bx-input__input d-flex align-center justify-space-between">
                    
                        <input type="text"  style="text-align: left;" id="name_crpromo" placeholder="ПРОМОКОД">
                   
                </div>
                <div class="bx-input__input d-flex align-center justify-space-between">
                    
                        <input style="text-align: left;"  type="text" id="sum_crpromo" placeholder="СУММА">
                        <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg>
                    
                </div>
            </div>
            <div class="bx-input__create-coupon">
                <div class="bx-input__input d-flex align-center justify-space-between">
                    
                        <input type="text" style="text-align: left;" placeholder="КОЛИЧЕСТВО АКТИВАЦИЙ" id="act_crpromo" placeholder="0.00">
                        <svg class="icon money"><use xlink:href="images/symbols.svg#users"></use></svg>
                   
                </div>
                <a onclick="disable(this);createPromoUser(this)" style="height: 55px;" class="btn is-ripples flare btn--red d-flex align-center justify-center" ><span>Создать</span></a>
            </div>
            
        </div>
    </div> 
</div>
<div class="popup popup--send">
    <div class="popup__title d-flex align-center justify-space-between">
        <div class="popup__tabs d-flex align-center">
            <div class="popup__tab popup__tab--active d-flex align-center">
                <svg class="icon"><use xlink:href="images/symbols.svg#minus"></use></svg>
                <span>Перевод средств</span>
            </div>
            <div class="popup__tab d-flex align-center" rel="popup" data-popup="popup--coupon">
                <svg class="icon"><use xlink:href="images/symbols.svg#plus"></use></svg>
                <span>Промокод</span>
            </div>
        </div>
        <a href="#" class="close d-flex align-center justify-center">
            <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
        </a>
    </div>
    <div class="popup__content">
        <div class="bx-input">
            <div class="bx-input__create-coupon">
                <div class="bx-input__input d-flex align-center justify-space-between">
                    <label class="d-flex align-center">ID игрока:</label>
                    <div class="d-flex align-center">
                        <input type="text" placeholder="ID">
                    </div>
                </div>
                <div class="bx-input__input d-flex align-center justify-space-between">
                    <label class="d-flex align-center">Сумма:</label>
                    <div class="d-flex align-center">
                        <input type="text" placeholder="0.00">
                        <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg>
                    </div>
                </div>
            </div>
            <div class="bx-input__btn d-flex align-center">
                <a href="#" class="btn is-ripples flare btn--blue d-flex align-center"><span>Перевести</span></a>
                <div class="history__user d-flex align-center justify-center" style="margin-left: 10px">
                    <div class="history__user-avatar" style="background: url(https://sun1-47.userapi.com/s/v1/ig2/XpJjGMiNkluJe92SSJXtnBchRcr51JMc6-9JVxZO3ZMbCRjtmbKCjmpTRq_2_0cOZ6dVShhXRrA8i381ORNssVHX.jpg?size=200x200&amp;quality=95&amp;crop=31,8,944,944&amp;ava=1) no-repeat center center / cover;"></div>
                    <span>Владимир Макаров</span>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="popup popup--promo-history">
    <div class="popup__title d-flex align-center justify-space-between">
        <span>История промокодов</span>
        <a href="#" class="close d-flex align-center justify-center">
            <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
        </a>
    </div>
    <div class="popup__content">
        <div class="wallet__history">
            <div class="wallet__history-item d-flex justify-space-between align-center">
                <div class="wallet__history-left d-flex align-center">
                    <span style="font-weight: 600;margin-right: 20px;">7W8J9K0Q2G2O0A</span>
                    <div class="wallet__history-sum d-flex align-center">
                        <span>2 / 25 </span>
                        <svg class="icon money"><use xlink:href="images/symbols.svg#users"></use></svg>
                    </div>
                </div>
                <div class="wallet__history-status">
                    <span>Осталось: 3 активации</span>
                </div>
            </div>
        </div>
    </div>
</div>

@auth
<div class="popup popup--tg popup--about">
    <div class="popup__title d-flex align-center justify-space-between">
        <span>Телеграм</span>
        <a href="#" class="close d-flex align-center justify-center">
            <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
        </a>
    </div>
    <div class="popup__content">
        <p>Для привязки аккаунта напишите нашему боту <a href="https://t.me/{{\App\Setting::first()->tg_bot_id}}" target="_blank" style="cursor: pointer;">@<span style="cursor: pointer;">{{\App\Setting::first()->tg_bot_id}}</span></a> данное сообщение:</p>
        <div class="borders"></div>
        <p onclick="copyText(this)" style="text-align:center;width: 100%;font-size:18px;font-weight: 600;">/bind {{\Auth::user()->id}}</p>
        <div class="borders"></div>
        <a onclick="disable(this);checkTgConnect(this)" class="btn btn--red d-flex align-center justify-center is-ripples flare"><span>Проверить привязку</span></a>
    </div>
</div>
@endauth
<div class="popup popup--refill popup--about">
    <div class="popup__title d-flex align-center justify-space-between">
        <span>Пополнение</span>
        <a href="#" class="close d-flex align-center justify-center">
            <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
        </a>
    </div>
    <div class="popup__content">
        <div class="bx-input">
            <div class="bx-input__input d-flex align-center justify-space-between">
                <label class="d-flex align-center">Счёт:</label>
                <div class="d-flex align-center">
                    <span class="bx-input__text" id="wallet_pay" onclick="copyText('wallet_pay')">79002224132</span>
                    <a href="#" onclick="copyText('wallet_pay')" class="btn btn--blue is-ripples flare d-flex align-center" style="margin-left:5px;"><span>Copy</span></a>
                </div>
            </div> 
        </div>
        <div class="bx-input">
            <div class="bx-input__input d-flex align-center justify-space-between">
                <label class="d-flex align-center">Комментарий:</label>
                <div class="d-flex align-center">
                    <span class="bx-input__text" id="comment_pay" onclick="copyText('comment_pay')">39618</span>
                    <a href="#" onclick="copyText('comment_pay')" class="btn btn--blue is-ripples flare d-flex align-center" style="margin-left:5px;"><span>Copy</span></a>
                </div>
            </div>
        </div>
        <div class="bx-input">
            <div class="bx-input__input d-flex align-center justify-space-between">
                <label class="d-flex align-center">Сумма перевода:</label>
                <div class="d-flex align-center">
                    <span class="bx-input__text" id="sum_pay" onclick="copyText('sum_pay')">100</span>
                    <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg>
                    <a href="#" onclick="copyText('sum_pay')" class="btn btn--blue is-ripples flare d-flex align-center" style="margin-left:5px;"><span>Copy</span></a>
                </div>
            </div>
        </div>
        <div class="bx-input">
            <a id="check_pay"  class="btn btn--red d-flex align-center justify-center is-ripples flare"><span>Проверить перевод</span></a>
        </div>
        <div class="borders"></div>
        <p>При переводе вы должны в точности указать номер кошелька, сумму, комментарий. В случае ошибки деньги не возвращаем.</p>
    </div>
</div>
<script>
    function copyText(that){
        var $temp = $("<input>"); 
        $("body").append($temp);
        $temp.val($(that).text()).select();
        document.execCommand("copy");
        $temp.remove();

        notification('success', 'Скопировано!')
    }
</script>
@if(\Auth::user() && (\Auth::user()->admin == 1 or \Auth::user()->admin == 2)) 
<script type="text/javascript">
    function  typeChatBan() {
        type = $('#type_chat_ban').val();
        $('#type_ban_2').hide()
        $('#time_chat_ban').val('')
        if(type == 2){
            $('#type_ban_2').show()
        }
    }
</script>
<div class="popup popup--ban popup--about">
    <div class="popup__title d-flex align-center justify-space-between">
        <span>Забанить</span>
        <a href="#" class="close d-flex align-center justify-center">
            <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
        </a>
    </div>
    <input type="hidden" id="chat_id_ban" name="">
    <div class="popup__content">
        <div class="bx-input bx-input--select d-flex flex-column" >
            <label>Причина бана</label>
            <select class="select" id="why_chat_ban">
                <option value="1">Попрошайничество</option>
                <option value="2">Распространение реф кодов</option>
                <option value="3">Оскорбление</option>
                <option value="4">Спам</option>
                <option value="5">Слив промо</option>
                <option value="6">Пиар</option>
                <option value="7">Клевета</option>
                <option value="8">Введение в заблуждение</option>
            </select>
        </div>
        <div class="bx-input bx-input--select d-flex flex-column" >
            <label>Бан</label>
            <select class="select" id="type_chat_ban" onchange="typeChatBan()">
                <option value="1">Навсегда</option>
                <option value="2">До какого-то время</option>
            </select>
        </div>
        <div class="bx-input d-flex flex-column" id="type_ban_2" style="display: none;">
            <div class="bx-input__input d-flex align-center justify-space-between">
                <label class="d-flex align-center">Время:</label>
                <div class="d-flex align-center">
                    <input type="datetime-local" id="time_chat_ban">
                </div>
            </div>
        </div>
        <div class="bx-input">
            <a onclick="banMess()" class="btn btn--red d-flex align-center justify-center is-ripples flare"><span>Забанить</span></a>
        </div>
    </div>
</div>
@endif

<div class="popup popup--x30 popup--about">
    <div class="popup__title d-flex align-center justify-space-between">
        <span>Режим «x30»</span>
        <a href="#" class="close d-flex align-center justify-center">
            <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
        </a>
    </div>
    <div class="popup__content">
        <p>В этом режиме вам предстоит выбрать цвет или цвета и сделать ставку. Если угадаете цвет, который выпадет, то вы выиграли.</p>
        <div class="borders"></div>
        <h4>Возможные ставки:</h4>
        <div class="bets">
            <div class="x30__bet-heading is-ripples flare x2 d-flex align-center justify-space-between">
                <span>X2</span>
                <img src="images/games/x2.svg">
            </div>
            <div class="x30__bet-heading is-ripples flare x3 d-flex align-center justify-space-between">
                <span>X3</span>
                <img src="images/games/x3.svg">
            </div>
            <div class="x30__bet-heading is-ripples flare x5 d-flex align-center justify-space-between">
                <span>X5</span>
                <img src="images/games/x5.svg">
            </div>
            <div class="x30__bet-heading is-ripples flare x7 d-flex align-center justify-space-between">
                <span>X7</span>
                <img src="images/games/x7.svg">
            </div>
            <div class="x30__bet-heading is-ripples flare x14 d-flex align-center justify-space-between">
                <span>X14</span>
                <img src="images/games/x14.svg">
            </div>
            <div class="x30__bet-heading is-ripples flare x30 d-flex align-center justify-space-between">
                <span>X30</span>
                <img src="images/games/x30.svg">
            </div>
        </div>
        <div class="borders"></div>
        <p>Также присуствует бонусная игра, при выпадении которой начинается выбор мультиплеера (от 2х до 7х).</p>
    </div>
</div>

<div class="popup popup--x100 popup--about">
    <div class="popup__title d-flex align-center justify-space-between">
        <span>Режим «x100»</span>
        <a href="#" class="close d-flex align-center justify-center">
            <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
        </a>
    </div>
    <div class="popup__content x100">
        <p>В этом режиме вам предстоит выбрать цвет или цвета и сделать ставку. Если угадаете цвет, который выпадет, то вы выиграли.</p>
        <div class="borders"></div>
        <h4>Возможные ставки:</h4>
        <div class="bets">
            <div class="x30__bet-heading is-ripples flare x2 d-flex align-center justify-space-between">
                <span>X2</span>
                <!-- <img src="images/games/x2.svg"> -->
            </div>
            <div class="x30__bet-heading is-ripples flare x3 d-flex align-center justify-space-between">
                <span>X3</span>
                <!-- <img src="images/games/x3.svg"> -->
            </div>
            <div class="x30__bet-heading is-ripples flare x10 d-flex align-center justify-space-between">
                <span>X10</span>
                <!-- <img src="images/games/x5.svg"> -->
            </div>
            <div class="x30__bet-heading is-ripples flare x15 d-flex align-center justify-space-between">
                <span>X15</span>
                <!-- <img src="images/games/x7.svg"> -->
            </div>
            <div class="x30__bet-heading is-ripples flare x20 d-flex align-center justify-space-between">
                <span>X20</span>
                <!-- <img src="images/games/x14.svg"> -->
            </div>
            <div class="x30__bet-heading is-ripples flare x100 d-flex align-center justify-space-between" >
             <span>X100</span>
             <!-- <img src="images/games/x30.svg"> -->
         </div>
     </div>
     <div class="borders"></div>
     <p>Также присуствует бонусная игра, выпадает она в случайную игру. При выпадении, начинается выбор игрока, укоторого выигрыш умножится на 4х.</p>
 </div>
</div>
<div class="popup popup--about popup--hits">
    <div class="popup__title d-flex align-center justify-space-between">
        <span>Достижения</span>
        <a href="#" class="close d-flex align-center justify-center">
            <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
        </a>
    </div>
    <div class="popup__content">
        <table>
            <thead>
                <tr>
                    <td>Название</td>
                    <td>Депозит</td>
                    <td>Бонус</td>
                </tr>
            </thead>
            <tbody id="all_status_table">
                <tr>
                    <td>
                        <span class="user-status wolf">Волк</span>
                    </td>
                    <td>
                        <span>100</span>
                    </td>
                    <td>
                        <span>10</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span class="user-status predator">Хищник</span>
                    </td>
                    <td>
                        <span>500</span>
                    </td>
                    <td>
                        <span>50</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span class="user-status premium">Премиум</span>
                    </td>
                    <td>
                        <span>1000</span>
                    </td>
                    <td>
                        <span>100</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span class="user-status alpha">Альфа</span>
                    </td>
                    <td>
                        <span>2500</span>
                    </td>
                    <td>
                        <span>250</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span class="user-status vip">Вип</span>
                    </td>
                    <td>
                        <span>5000</span>
                    </td>
                    <td>
                        <span>500</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span class="user-status professional">Профи</span>
                    </td>
                    <td>
                        <span>10000</span>
                    </td>
                    <td>
                        <span>1000</span>
                    </td>
                </tr>
                <tr>
                    <td>
                        <span class="user-status legend">Легенда</span>
                    </td>
                    <td>
                        <span>50000</span>
                    </td>
                    <td>
                        <span>5000</span>
                    </td>
                </tr>
            </tbody>
        </table>
        <div class="borders"></div>
        <p>Достижение - это уровень, для получения которого необходимо выполнить требования по общей сумме пополнений на сайте за все время. Требования для каждого достижения приведены выше. При получении нового достижения игроку выдается одноразовый бонус в размере, указанном в колонке "Бонус".</p>
    </div>
</div>

<div class="popup popup--rules">
            <div class="popup__title d-flex align-center justify-space-between">
                <span>Правила чата</span>
                <a href="#" class="close d-flex align-center justify-center">
                    <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
                </a>
            </div>
            <div class="popup__content">
                <h3>В чате запрещено</h3>
                <ol class="show_ul">
                    <li>Сливать промо / секретные коды</li>
                    <li>Попрошайничество</li>
                    <li>Оскорблять администрацию</li>
                    <li>Показывать чрезмерную агрессию и негатив</li>
                    <li>Обвинять администрацию сайта или сайт в обмане</li>
                    <li>Рекламировать сторонние ресурсы</li>
                    <li>Спамить / Флудить</li>
                    <li>Разжигание ненависти</li>
                    <li>Рекламировать реферальный код</li>
                </ol>

                <p class="text-attation">Эмоции после поражения могут сыграть с Вами злую шутку.<br> И помните: Вы всегда можете вывести средства.</p>


                <br>
                <div class="bx-input">
                    <a onclick="localStorage.setItem('crashAgree', 'true');;$('.close').click()" class="btn btn--red d-flex align-center justify-center is-ripples flare"><span>Я ознакомлен. Закрыть</span></a>
                </div>

            </div>
        </div>

<div class="popup popup--fair-dice" style="width: 375px;">
    <div class="popup__title d-flex align-center justify-space-between">
        <span>Dice</span>
        <a href="#" class="close d-flex align-center justify-center">
            <svg class="icon"><use xlink:href="images/symbols.svg#close"></use></svg>
        </a>
    </div>
    <div class="popup__content">
        <div class="dice__check d-flex align-center flex-column">
            <div class="dice__check-chance" id="chanse_dice">30 <</div>
            <div class="dice__check-result dice__check-result--lose d-flex align-end">
                <span id="dice_n_1_check">2</span>
                <span id="dice_n_2_check">9</span>
                <b>,</b>
                <span id="dice_n_3_check">4</span>
                <span id="dice_n_4_check">2</span>
            </div>
        </div>
        <div class="mines__check d-flex justify-space-between align-center">
            <div class="mines__check-sum d-flex align-center">
                <span id="dice_bet">2,212</span>
                <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg>
            </div>
            <span id="dice_coeff">x3.33</span>
            <div class="mines__check-sum mines__check-sum--total d-flex align-center">
                <span id="dice_win">2,212</span>
                <svg class="icon money"><use xlink:href="images/symbols.svg#coins"></use></svg>
            </div>
        </div>
        <div class="popup__fair d-flex flex-column">
            <div class="popup__fair-item d-flex align-start">
                <b>Full string</b>
                <span id="full_dice">18324ufjdfh2ihi[[123,kmjf</span>
            </div>
            <div class="popup__fair-item d-flex align-start">
                <b>Hash</b>
                <span id="hash_dice">17273721fd9f1jf9idmm11fdi231ij1mjidfhysygu8tgkjmsjgmsgu</span>
            </div>
            <div class="popup__fair-item d-flex align-start">
                <b>Salt1</b>
                <span id="salt1_dice">(6dsi2j,j2,f,[][])</span>
            </div>
            <div class="popup__fair-item d-flex align-start">
                <b>Number</b>
                <span id="number_dice">7772381</span>
            </div>
            <div class="popup__fair-item d-flex align-start">
                <b>Salt2</b>
                <span id="salt2_dice">Q7237yhhiw223r</span>
            </div>
        </div>
    </div>
</div>

</div>

<script type="text/javascript">
    var ADMIN_CHAT = ''
    @guest
    var USER_AVA = '';
    var USER_ID = 0;
    var ADMIN_CHAT = '';
    @else 

    var USER_ID = {{\Auth::user()->id}};
    @if(\Auth::user()->admin == 1) 
    var ADMIN_CHAT = '<div class="chat__buttons-admins">\
    <a href="#"><svg class="icon"><use xlink:href="/images/symbols.svg#close"></use></svg></a>\
    <a href="#" rel="popup" data-popup="popup--ban"><svg class="icon" style="width: 20px; height: 20px"><use xlink:href="/images/symbols.svg#warning"></use></svg></a>\
    </div>';
    @endif
    @endif
</script>

<script src="js/fireworks.js" type="text/javascript"></script>

<script>

    window.onload = function () {
        var firework = JS_FIREWORKS.Fireworks({
            id : 'fireworks-canvas',
            hue : 120,
            particleCount : 50,
            delay : 0,
            minDelay : 20,
            maxDelay : 40,
            fireworkSpeed : 3,
            fireworkAcceleration : 1.05,
            particleFriction : .95,
            particleGravity : 1.5
        });
        firework.start();
        var firework2 = JS_FIREWORKS.Fireworks({
            id : 'fireworks-canvas2',
            hue : 120,
            particleCount : 50,
            delay : 0,
            minDelay : 20,
            maxDelay : 40,
            fireworkSpeed : 4,
            fireworkAcceleration : 1.05,
            particleFriction : .95,
            particleGravity : 1.5
        });
        firework2.start();
    };

   

    @auth
    balanceUpdate(0, {{\Auth::user()->type_balance == 0 ? \Auth::user()->balance : \Auth::user()->demo_balance}}, 1)
    @endauth
    $('#btnSmiles').click(function(e) {
        e.preventDefault()
        $('.chat').toggleClass('chat--smiles').removeClass('chat--stickers');
        $('#btnStickers').removeClass('active');
        $(this).toggleClass('active');
    });
    $('#btnStickers').click(function(e) {
        e.preventDefault()
        $('#btnSmiles').removeClass('active');
        $('.chat').toggleClass('chat--stickers').removeClass('chat--smiles');
        $(this).toggleClass('active');
    });
    $('#dropdownUser').click(function(e){
        e.preventDefault()
        $(this).toggleClass('dropdown');
    });
    $(document).on('click', function(e) {
        if (!$(e.target).closest("#dropdownUser").length) {
            $('.header__user-dropdown').parent().removeClass('dropdown');
        }
        e.stopPropagation();
    });

    $(".popup--wallet .popup__content .wallet").not(":first").hide();
    $(".popup--wallet .popup__tab").click(function () {
        if ($(this).hasClass('popup__tab--active')) {

        } else {
            $(".popup--wallet .popup__content .wallet").hide().eq($(this).index()).fadeIn(500);
        }
        $('.popup--wallet .popup__tab.popup__tab--active').removeClass('popup__tab--active');
        $(this).addClass('popup__tab--active');
        return false;
    });

    $('.wallet--refill .wallet__method').click(function(e) {
        e.preventDefault()
        if ($(this).hasClass('active')) {

        } else {
            $('.wallet--refill .wallet__method.wallet__method--active').removeClass('wallet__method--active')
            $(this).addClass('wallet__method--active')
        }
    });

    $('.wallet--withdraw .wallet__method').click(function(e) {
        e.preventDefault()
        if ($(this).hasClass('active')) {

        } else {
            $('.wallet--withdraw .wallet__method.wallet__method--active').removeClass('wallet__method--active')
            $(this).addClass('wallet__method--active')
        }
    });

    $(".popup--wallet .popup__content .wallet__history").not(":first").hide();
    $(".wallet--history .wallet__tab").click(function () {
        if ($(this).hasClass('wallet__tab--active')) {

        } else {
            $(".popup--wallet .popup__content .wallet__history").hide().eq($(this).index()).fadeIn(500);
        }
        $('.wallet--history .wallet__tab.wallet__tab--active').removeClass('wallet__tab--active');
        $(this).addClass('wallet__tab--active');
        return false;
    });


    $('.close').click(function(e) {
        setTimeout(() => {
            $('.overlayed, .popup, body').removeClass('active');
        }, 100)
        $('.overlayed').addClass('animation-closed')
        return false;
    });
    $('.overlayed').click(function(e) {
        var target = e.target || e.srcElement;
        if(!target.className.search('overlay')) {
            setTimeout(() => {
                $('.overlayed, .popup, body').removeClass('active');
            }, 100)
            $('.overlayed').addClass('animation-closed') 
        } 
    }); 
    $(document).ready(function() {
        // captcha_r()
        $(document).on("click","[rel=popup]",function() {

            showPopup($(this).attr('data-popup'));
            return false;
        });

    });

    function showPopup(el) {
        if($('.popup').is('.active')) {
            $('.popup').removeClass('active');  
        }
        $('.overlayed, body, .popup.'+el).addClass('active');
        $('.overlayed').removeClass('animation-closed');
    }



    socket.on('laravel_database_x100Bet',e => {
        e = $.parseJSON(e)
        e = e.data
        class_dop = ''
        if(e.user_id == USER_ID){
            class_dop = 'img_no_blur'
        }
        dopText = ''
        @auth
        @if(\Auth::user()->admin == 1)
        dopText = '<div class="dopPlusBetX100" onclick="getX100Bonus('+e.user_id+', `'+e.img+'`)">Bonus</div>'
        @endif
        @endauth
        $('.x100 .x100__bet-users.x'+e.coff).prepend('<div data-user-id='+e.user_id+' class="x30__bet-user d-flex align-center justify-space-between">'+dopText+'\
            <div class="history__user d-flex align-center justify-center">\
            <div class="history__user-avatar '+class_dop+'" style="background: url('+e.img+') no-repeat center center / cover;"></div>\
            <span>'+e.login+'</span>\
            </div>\
            <div class="x30__bet-sum d-flex align-center">\
            <span>'+(Number(e.bet).toFixed(2))+'</span>\
            <svg class="icon money" style="margin-left: 8px;"><use xlink:href="images/symbols.svg#coins"></use></svg>\
            </div>\
            </div>')

        $('span[data-sumBetsX100='+e.coff+']').html((e.sumBets).toFixed(0))
        $('span[data-playersX100='+e.coff+']').html(e.players)

    })


    function chatAdd(data){
        class_dop = ''
        if(data.user_id == USER_ID || data.type_mess != 0){
            class_dop = 'img_no_blur'
        }

        @if($setting->theme == 0)
            ava = '<div class="chat__msg-avatar '+class_dop+'" style="background: url('+data.avatar+') no-repeat center center / cover;"></div> '
        @else
            ava = '<div class="chat__msg-avatar '+class_dop+'" style="background: url('+data.avatar+') no-repeat center center / cover;"><img src="../images/games/cap_new.png?v=1" class="cap_new"></div> '
        @endif

        
        class_mess = 'mess';


        if(data.type_mess == 4){
            class_mess = 'system_mess';
            @if($setting->theme == 0)
                        ava = '<div class="chat__msg-avatar '+class_dop+'" ></div>';
                        @else
                            ava = '<div class="chat__msg-avatar '+class_dop+'" ><img src="../images/games/cap_new.png?v=1" class="cap_new"></div>';
                        @endif
        }




        dopAdminText = ''
        @if(\Auth::user() && (\Auth::user()->admin == 1 or \Auth::user()->admin == 2))  
        dopAdminText =  '<div class="chat__buttons-admins">\
        <a onclick="deleteMess('+data.id+')"><svg class="icon"><use xlink:href="/images/symbols.svg#close"></use></svg></a>\
        <a onclick="banMessSetId('+data.id+')"  rel="popup" data-popup="popup--ban"><svg class="icon" style="width: 20px; height: 20px;pointer-events: none"><use xlink:href="/images/symbols.svg#warning"></use></svg></a>\
        </div>'
        @endif


        $('.chat__messages .ss-wrapper .ss-content').append('<div id="msg_'+data.id+'" class="chat__msg d-flex align-start">\
            '+ava+'\
            <div class="chat__msg-info d-flex flex-column">\
            <b>'+data.time+'</b>\
            <span>'+data.status_mess+' '+data.autor+'</span>\
            <div class="chat__msg-message '+class_mess+'">\
            <span>'+data.content+'</span>\
            </div>\
            '+dopAdminText+'\
            </div>\
            </div>');

        chatScroll() 


    }



    function chatGet(){
        $.post('/chat/get',{_token: csrf_token}).then(e=>{
            if(e.history){
                $('.chat__messages .ss-wrapper .ss-content').html('');
                e.history.forEach((e)=>{
                    data = e


                    class_dop = ''
                    if(data.user_id == USER_ID || data.type_mess != 0){
                        class_dop = 'img_no_blur'
                    }

                    @if($setting->theme == 0)
                        ava = '<div class="chat__msg-avatar '+class_dop+'" style="background: url('+data.avatar+') no-repeat center center / cover;"></div> '
                    @else
                        ava = '<div class="chat__msg-avatar '+class_dop+'" style="background: url('+data.avatar+') no-repeat center center / cover;"><img src="../images/games/cap_new.png?v=1" class="cap_new"></div> '
                    @endif
                    
                    class_mess = 'mess';


                    if(data.type_mess == 4){
                        class_mess = 'system_mess';
                        @if($setting->theme == 0)
                        ava = '<div class="chat__msg-avatar '+class_dop+'" ></div>';
                        @else
                            ava = '<div class="chat__msg-avatar '+class_dop+'" ><img src="../images/games/cap_new.png?v=1" class="cap_new"></div>';
                        @endif
                        
                    }

                    

                    dopAdminText = ''
                    @if(\Auth::user() && (\Auth::user()->admin == 1 or \Auth::user()->admin == 2))  
                    dopAdminText =  '<div class="chat__buttons-admins">\
                    <a onclick="deleteMess('+data.id+')"><svg class="icon"><use xlink:href="/images/symbols.svg#close"></use></svg></a>\
                    <a onclick="banMessSetId('+data.id+')"  rel="popup" data-popup="popup--ban"><svg class="icon" style="width: 20px; height: 20px;pointer-events: none"><use xlink:href="/images/symbols.svg#warning"></use></svg></a>\
                    </div>'
                    @endif


                    $('.chat__messages .ss-wrapper .ss-content').prepend('<div id="msg_'+data.id+'" class="chat__msg d-flex align-start">\
                        '+ava+'\
                        <div class="chat__msg-info d-flex flex-column">\
                        <b>'+data.time+'</b>\
                        <span>'+data.status_mess+' '+data.autor+'</span>\
                        <div class="chat__msg-message '+class_mess+'">\
                        <span>'+data.content+'</span>\
                        </div>\
                        '+dopAdminText+'\
                        </div>\
                        </div>');

                    chatScroll()

                })


            } 

        })
    }


    chatGet()


    @if(\Auth::user() && (\Auth::user()->admin == 1 or \Auth::user()->admin == 2))  
    function deleteMess(id){

        $.post('/chat/delete',{_token: csrf_token, id}).then(e=>{
          if(e.success){
            notification('success','Успешно')
        }else{      
            notification('error',e.mess)
        }
    })
    }
    function banMessSetId(id){
        $('#chat_id_ban').val(id)
    }
    function banMess(){
        why_ban = $('#why_chat_ban').val()
        time_ban = $('#time_chat_ban').val()
        id = $('#chat_id_ban').val()
        $.post('/chat/ban',{_token: csrf_token, id, why_ban, time_ban}).then(e=>{

          if(e.success){
            notification('success','Успешно')
        }else{    
            notification('error',e.mess)
        }
    })
    }




    @endif  



    activeLinks()


    var captcha_r = function () {
        $('#captcha_reload').html('<div style="width:100%" class="h-captcha" id="captcha"  data-sitekey="952c2020-3e6b-43fe-b941-4659cb499ec7"></div>')
        console.log('hCaptcha is ready.');
        var widgetID = hcaptcha.render('captcha', { sitekey: '952c2020-3e6b-43fe-b941-4659cb499ec7' });
    };
    


</script>


    @auth
    @if(\Auth::user()->id != 0)
    <script type="text/javascript">


        function openWinter(id){
            $.post('/winter/start',{_token: csrf_token, id}).then(e=>{
                undisable('.winter__item')   
                if(e.success){  
                    
                    e.prize.forEach(function(item, i, arr) {
                        $('.winter__item:eq('+i+') .winter__front span').html(item+' Р')

                    })  
                   
                    balanceUpdate(e.lastbalance, e.newbalance)
                    notification('success',e.success)
                    notification('success','С Новым годом!')

                    $('.winter__item:eq('+(id - 1)+')').addClass('winter__item--active')

                    setTimeout(() => $('.winter__item').addClass('winter__item--active'),1000);

                    setTimeout(() => location.href='/',2000);

                }else{       
                    notification('error',e.mess)
                }
            }).fail(e=>{
                undisable('.winter__item')   
                notification('error',JSON.parse(e.responseText).message)
            })  
        }

       

        socket.on('laravel_database_openNewYear', function(data){
            $('.winter').fadeIn();
        }) 

        socket.on('laravel_database_closeNewYear', function(data){
            $('.winter').fadeOut();
        }) 

    </script>
    

    @if(\Auth::user()->newYear == 0 && \App\Setting::first()->newYear == 1)
    <script type="text/javascript">
        $('.winter').fadeIn();
    </script>
    @endif

    @endif

    <script type="text/javascript">
        socket.emit('subscribe', 'roomUser_{{\Auth::user()->id}}');
    </script>
    @endauth






</body>
</html>

<style type="text/css">
    @media(max-width: 475px){
  .toast-top-right{
    margin-top: 60px!important;
  }
}
</style>