/**
 * Copyright (c) Jonathan Cardoso Machado. All Rights Reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Object with constants for usage with the info `PROXY_ERROR`
 *
 * `CURLPX_OK` becomes `CurlPx.Ok`
 *
 * @public
 */
export declare enum CurlPx {
    Ok = 0,
    BadAddressType = 1,
    BadVersion = 2,
    Closed = 3,
    Gssapi = 4,
    GssapiPermsg = 5,
    GssapiProtection = 6,
    Identd = 7,
    IdentdDiffer = 8,
    LongHostname = 9,
    LongPasswd = 10,
    LongUser = 11,
    NoAuth = 12,
    RecvAddress = 13,
    RecvAuth = 14,
    RecvConnect = 15,
    RecvReqack = 16,
    ReplyAddressTypeNotSupported = 17,
    ReplyCommandNotSupported = 18,
    ReplyConnectionRefused = 19,
    ReplyGeneralServerFailure = 20,
    ReplyHostUnreachable = 21,
    ReplyNetworkUnreachable = 22,
    ReplyNotAllowed = 23,
    ReplyTtlExpired = 24,
    ReplyUnassigned = 25,
    RequestFailed = 26,
    ResolveHost = 27,
    SendAuth = 28,
    SendConnect = 29,
    SendRequest = 30,
    UnknownFail = 31,
    UnknownMode = 32,
    UserRejected = 33
}
//# sourceMappingURL=CurlPx.d.ts.map