/**
 * Copyright (c) Jonathan Cardoso Machado. All Rights Reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
/**
 * Object with constants on the {@link FileInfo | `FileInfo`} object,
 *  used alongside the `CHUNK_BGN_FUNCTION` option
 *
 * `CURLFILETYPE_DEVICE_BLOCK` becomes `CurlFileType.DeviceBlock`
 *
 * @public
 */
export declare enum CurlFileType {
    File = 0,
    Directory = 1,
    Symlink = 2,
    DeviceBlock = 3,
    DeviceChar = 4,
    NamedPipe = 5,
    Socket = 6,
    Door = 7
}
//# sourceMappingURL=CurlFileType.d.ts.map